var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var Constants = (function () {
                    function Constants() {
                    }
                    Object.defineProperty(Constants, "agentOnByDefaultClassId", {
                        get: function () {
                            return "4EA90761-2248-496C-B854-3C0399A591A4";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "agentOffByDefaultClassId", {
                        get: function () {
                            return "ABC0828F-EB2D-4DA7-80AE-B86BE757631D";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callTreeAnalysisDetailsViewId", {
                        get: function () {
                            return "DCA8B3EF-17B4-4B08-BAFC-B072F8AA9277";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "cpuSamplingAnalyzer", {
                        get: function () {
                            return "DCA8B3EF-28C5-4B08-BAFC-B072F8AA9277";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callTreePerformanceDebuggerDetailsViewId", {
                        get: function () {
                            return "14A21806-86A1-4BB4-98CD-0246476FF305";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "functionsAnalysisDetailsViewId", {
                        get: function () {
                            return "7D95F423-6D5E-488C-B3A9-169D6D297D5C";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callerCalleePerformanceDebuggerViewId", {
                        get: function () {
                            return "7EF59745-BD0B-4429-8782-41FB55495DA1";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callerCalleeAnalysisViewId", {
                        get: function () {
                            return "9878B5B0-8B34-4D9F-A648-17F727EBE7DA";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "functionsPerformanceDebuggerDetailsViewId", {
                        get: function () {
                            return "47660699-1BCE-4442-AEA7-A520683BDA66";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "errorNameCanceled", {
                        get: function () {
                            return "Canceled";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "samplesPerSecond", {
                        get: function () {
                            return 1000;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callerCalleeViewModelMappingKey", {
                        get: function () {
                            return "CallerCalleeView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(Constants, "callTreeViewModelMappingKey", {
                        get: function () {
                            return "CallTreeView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    return Constants;
                }());
                CpuUsage.Constants = Constants;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                (function (DataLoadEvent) {
                    DataLoadEvent[DataLoadEvent["DataLoadStart"] = 0] = "DataLoadStart";
                    DataLoadEvent[DataLoadEvent["DataLoadCompleted"] = 1] = "DataLoadCompleted";
                    DataLoadEvent[DataLoadEvent["DataLoadFailed"] = 2] = "DataLoadFailed";
                    DataLoadEvent[DataLoadEvent["DataLoadCanceled"] = 3] = "DataLoadCanceled";
                })(CpuUsage.DataLoadEvent || (CpuUsage.DataLoadEvent = {}));
                var DataLoadEvent = CpuUsage.DataLoadEvent;
                (function (SortColumn) {
                    SortColumn[SortColumn["Id"] = 1] = "Id";
                    SortColumn[SortColumn["FunctionName"] = 2] = "FunctionName";
                    SortColumn[SortColumn["InclusiveSamples"] = 3] = "InclusiveSamples";
                    SortColumn[SortColumn["ExclusiveSamples"] = 4] = "ExclusiveSamples";
                    SortColumn[SortColumn["InclusivePercent"] = 5] = "InclusivePercent";
                    SortColumn[SortColumn["ExclusivePercent"] = 6] = "ExclusivePercent";
                    SortColumn[SortColumn["ModuleName"] = 7] = "ModuleName";
                })(CpuUsage.SortColumn || (CpuUsage.SortColumn = {}));
                var SortColumn = CpuUsage.SortColumn;
                (function (SortDirection) {
                    SortDirection[SortDirection["Asc"] = 1] = "Asc";
                    SortDirection[SortDirection["Desc"] = 2] = "Desc";
                })(CpuUsage.SortDirection || (CpuUsage.SortDirection = {}));
                var SortDirection = CpuUsage.SortDirection;
                (function (ResultTaskType) {
                    ResultTaskType[ResultTaskType["Expand"] = 1] = "Expand";
                    ResultTaskType[ResultTaskType["Search"] = 2] = "Search";
                    ResultTaskType[ResultTaskType["GetData"] = 3] = "GetData";
                    ResultTaskType[ResultTaskType["Sort"] = 4] = "Sort";
                })(CpuUsage.ResultTaskType || (CpuUsage.ResultTaskType = {}));
                var ResultTaskType = CpuUsage.ResultTaskType;
                (function (AggregateType) {
                    AggregateType[AggregateType["Unknown"] = 0] = "Unknown";
                    AggregateType[AggregateType["SystemCode"] = 1] = "SystemCode";
                    AggregateType[AggregateType["JmcRejected"] = 2] = "JmcRejected";
                    AggregateType[AggregateType["ResumingAsyncMethod"] = 3] = "ResumingAsyncMethod";
                })(CpuUsage.AggregateType || (CpuUsage.AggregateType = {}));
                var AggregateType = CpuUsage.AggregateType;
                (function (JmcState) {
                    JmcState[JmcState["UnknownCode"] = 0] = "UnknownCode";
                    JmcState[JmcState["SystemCode"] = 1] = "SystemCode";
                    JmcState[JmcState["LibraryCode"] = 2] = "LibraryCode";
                    JmcState[JmcState["UserCode"] = 3] = "UserCode";
                    JmcState[JmcState["MarkedHiddenCode"] = 4] = "MarkedHiddenCode";
                })(CpuUsage.JmcState || (CpuUsage.JmcState = {}));
                var JmcState = CpuUsage.JmcState;
                (function (ActivityType) {
                    ActivityType[ActivityType["Unknown"] = 0] = "Unknown";
                    ActivityType[ActivityType["ThreadRun"] = 1] = "ThreadRun";
                    ActivityType[ActivityType["AsyncTask"] = 2] = "AsyncTask";
                })(CpuUsage.ActivityType || (CpuUsage.ActivityType = {}));
                var ActivityType = CpuUsage.ActivityType;
                (function (ViewVisibility) {
                    ViewVisibility[ViewVisibility["Visible"] = 0] = "Visible";
                    ViewVisibility[ViewVisibility["Hidden"] = 1] = "Hidden";
                })(CpuUsage.ViewVisibility || (CpuUsage.ViewVisibility = {}));
                var ViewVisibility = CpuUsage.ViewVisibility;
                (function (ResultPreparationStatus) {
                    ResultPreparationStatus[ResultPreparationStatus["NotStarted"] = 0] = "NotStarted";
                    ResultPreparationStatus[ResultPreparationStatus["InProgress"] = 1] = "InProgress";
                    ResultPreparationStatus[ResultPreparationStatus["Completed"] = 2] = "Completed";
                    ResultPreparationStatus[ResultPreparationStatus["Canceled"] = 3] = "Canceled";
                    ResultPreparationStatus[ResultPreparationStatus["Failed"] = 4] = "Failed";
                })(CpuUsage.ResultPreparationStatus || (CpuUsage.ResultPreparationStatus = {}));
                var ResultPreparationStatus = CpuUsage.ResultPreparationStatus;
                (function (ResultNotStartedReason) {
                    ResultNotStartedReason[ResultNotStartedReason["Unknown"] = 0] = "Unknown";
                    ResultNotStartedReason[ResultNotStartedReason["NoValidTimeSelection"] = 1] = "NoValidTimeSelection";
                    ResultNotStartedReason[ResultNotStartedReason["NoValidThreadSelection"] = 2] = "NoValidThreadSelection";
                    ResultNotStartedReason[ResultNotStartedReason["ToolIsDisabled"] = 3] = "ToolIsDisabled";
                    ResultNotStartedReason[ResultNotStartedReason["TargetRunningUnderDebugger"] = 4] = "TargetRunningUnderDebugger";
                })(CpuUsage.ResultNotStartedReason || (CpuUsage.ResultNotStartedReason = {}));
                var ResultNotStartedReason = CpuUsage.ResultNotStartedReason;
                (function (ContextChangedSender) {
                    ContextChangedSender[ContextChangedSender["Unknown"] = 0] = "Unknown";
                    ContextChangedSender[ContextChangedSender["FlatFunctionsView"] = 1] = "FlatFunctionsView";
                    ContextChangedSender[ContextChangedSender["CallerCalleeView"] = 2] = "CallerCalleeView";
                    ContextChangedSender[ContextChangedSender["CallTreeView"] = 3] = "CallTreeView";
                    ContextChangedSender[ContextChangedSender["SourceBrowserView"] = 4] = "SourceBrowserView";
                })(CpuUsage.ContextChangedSender || (CpuUsage.ContextChangedSender = {}));
                var ContextChangedSender = CpuUsage.ContextChangedSender;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallTreeRowViewModel = (function () {
                    function CallTreeRowViewModel(parent, dto, depth) {
                        var _this = this;
                        this._selected = ko.observable(false);
                        this._haveLoaded = false;
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._parent = parent;
                        this._dto = dto;
                        this._depth = depth;
                        var children = [];
                        var expanded = false;
                        if (typeof this._dto.children !== "undefined") {
                            children = this._dto.children.map(function (childNode) {
                                return new CallTreeRowViewModel(_this, childNode, _this._depth + 1);
                            });
                            expanded = true;
                            this._haveLoaded = true;
                        }
                        this._children = ko.observableArray(children);
                        this._expanded = ko.observable(expanded);
                    }
                    Object.defineProperty(CallTreeRowViewModel.prototype, "templateName", {
                        get: function () {
                            return "CallTreeRowView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "id", {
                        get: function () {
                            return this._dto.id;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "depth", {
                        get: function () {
                            return this._depth;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "name", {
                        get: function () {
                            return this._dto.name;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "label", {
                        get: function () {
                            if (this._dto.name && this._parent !== null) {
                                switch (this._dto.jmcState) {
                                    case CpuUsage.JmcState.SystemCode:
                                        return Microsoft.Plugin.Resources.getString("SystemCallLabel");
                                    case CpuUsage.JmcState.LibraryCode:
                                        return Microsoft.Plugin.Resources.getString("ExternalCallLabel");
                                }
                            }
                            switch (this._dto.aggType) {
                                case CpuUsage.AggregateType.SystemCode:
                                    return Microsoft.Plugin.Resources.getString("SystemCodeLabel");
                                case CpuUsage.AggregateType.JmcRejected:
                                    return Microsoft.Plugin.Resources.getString("ExternalCodeLabel");
                                case CpuUsage.AggregateType.ResumingAsyncMethod:
                                    return Microsoft.Plugin.Resources.getString("ResumingAsyncMethodLabel");
                                default:
                                    return "";
                            }
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "inclusiveSamples", {
                        get: function () {
                            return this._dto.iSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "exclusiveSamples", {
                        get: function () {
                            return this._dto.eSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "inclusivePercent", {
                        get: function () {
                            return this._dto.iPercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "exclusivePercent", {
                        get: function () {
                            return this._dto.ePercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "moduleName", {
                        get: function () {
                            switch (this._dto.moduleCount) {
                                case 0:
                                    return Microsoft.Plugin.Resources.getString("UnknownModuleLabel");
                                case 1:
                                    if (this._dto.rtModule) {
                                        return Microsoft.Plugin.Resources.getString("DotNetNativeBuildTimeAndRuntimeModuleFormat", this._dto.moduleName, this._dto.rtModule);
                                    }
                                    return this._dto.moduleName;
                                default:
                                    return Microsoft.Plugin.Resources.getString("MultipleModuleLabel");
                            }
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "fileName", {
                        get: function () {
                            return this._dto.fileName || null;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "lineNumber", {
                        get: function () {
                            return (typeof this._dto.lineNumber === "number") ? this._dto.lineNumber : null;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "expandable", {
                        get: function () {
                            return typeof this._dto.children === "undefined" || this._dto.children.length > 0;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "selectionAddress", {
                        get: function () {
                            return this._dto.address;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "children", {
                        get: function () {
                            return this._children;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "expanded", {
                        get: function () {
                            return this._expanded;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeRowViewModel.prototype, "selected", {
                        get: function () {
                            return this._selected;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    CallTreeRowViewModel.prototype.invoke = function () {
                        var _this = this;
                        this._cpuToolMarshaler.getCurrentContext()
                            .then(function (previousToolContext) {
                            return _this._cpuToolMarshaler.raiseContextChangedEvent({
                                previousContext: previousToolContext,
                                currentContext: { viewContextSelectionAddress: _this.selectionAddress, selectionCallTreeNodeId: _this.id },
                                sender: CpuUsage.ContextChangedSender.CallTreeView
                            });
                        });
                    };
                    CallTreeRowViewModel.prototype.expand = function (dataWarehouseResult, sortParameters) {
                        var _this = this;
                        var dataLoadPromise = Microsoft.Plugin.Promise.as(void 0);
                        if (!this.expandable) {
                            return dataLoadPromise;
                        }
                        if (!this._haveLoaded) {
                            this._haveLoaded = true;
                            dataLoadPromise = dataWarehouseResult.getResult({
                                view: "call-tree",
                                type: CpuUsage.ResultTaskType.Expand,
                                sort: sortParameters,
                                path: this.getIdPath(),
                            }).then(function (childrenResult) {
                                childrenResult.callTreeData.map(function (childNode) {
                                    _this.children().push(new CallTreeRowViewModel(_this, childNode, _this._depth + 1));
                                });
                                _this._children.valueHasMutated();
                            });
                        }
                        this._expanded(!this._expanded());
                        return dataLoadPromise;
                    };
                    CallTreeRowViewModel.prototype.loadSourceBrowser = function (viewModel, event) {
                        viewModel.invoke();
                        return false;
                    };
                    CallTreeRowViewModel.prototype.getIdPath = function () {
                        if (!this._parent) {
                            return [this.id];
                        }
                        var path = this._parent.getIdPath();
                        path.unshift(this.id);
                        return path;
                    };
                    return CallTreeRowViewModel;
                }());
                CpuUsage.CallTreeRowViewModel = CallTreeRowViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CpuSamplingUtilities = (function () {
                    function CpuSamplingUtilities() {
                    }
                    CpuSamplingUtilities.numberComparator = function (left, right) {
                        return left - right;
                    };
                    CpuSamplingUtilities.asyncComputed = function (asyncFunc, hasChanged) {
                        var observedResult = ko.observable();
                        var dataLoadPromise;
                        var asyncComputed = observedResult;
                        var reevaluateTrigger = ko.observable().extend({ notify: "always" });
                        asyncComputed.reevaluate = function () { return reevaluateTrigger.valueHasMutated(); };
                        asyncComputed["_asyncRunner"] = ko.computed(function () {
                            reevaluateTrigger();
                            if (dataLoadPromise) {
                                dataLoadPromise.cancel();
                            }
                            dataLoadPromise = asyncFunc();
                            dataLoadPromise.done(function (result) {
                                dataLoadPromise = null;
                                observedResult(result);
                            }, function () {
                                dataLoadPromise = null;
                            });
                        });
                        if (hasChanged) {
                            hasChanged.addEventListener(function () { return asyncComputed.reevaluate(); });
                        }
                        return asyncComputed;
                    };
                    CpuSamplingUtilities.areBigNumbersEqual = function (left, right) {
                        return (!left && !right) ||
                            (left && right && left.h === right.h && left.l === right.l);
                    };
                    CpuSamplingUtilities.areTimespansEqual = function (left, right) {
                        return (!left && !right) ||
                            (left && right && left.equals(right));
                    };
                    CpuSamplingUtilities.areToolContextsEqual = function (left, right) {
                        return (!left && !right) ||
                            (left && right &&
                                CpuSamplingUtilities.areBigNumbersEqual(left.viewContextSelectionAddress, right.viewContextSelectionAddress) &&
                                left.selectionCallTreeNodeId === right.selectionCallTreeNodeId);
                    };
                    CpuSamplingUtilities.areResultStatusesEqual = function (left, right) {
                        return (!left && !right) ||
                            (left && right &&
                                left.taskId === right.taskId &&
                                left.resultId === right.resultId &&
                                left.preparationStatus === right.preparationStatus &&
                                left.notStartedReason === right.notStartedReason &&
                                left.completionPercentage === right.completionPercentage);
                    };
                    CpuSamplingUtilities.localizeNumber = function (value, options) {
                        var formatKey = JSON.stringify(options || {});
                        var numberFormatter = CpuSamplingUtilities.NumberFormatterMap[formatKey];
                        if (!numberFormatter) {
                            if (!window.Intl) {
                                numberFormatter = function (value) { return value.toLocaleString(Microsoft.Plugin.Culture.formatRegion, options); };
                                CpuSamplingUtilities.NumberFormatterMap[formatKey] = numberFormatter;
                            }
                            else {
                                var cachedFormat = (new Intl.NumberFormat(Microsoft.Plugin.Culture.formatRegion, options));
                                numberFormatter = function (value) { return cachedFormat.format(value); };
                                CpuSamplingUtilities.NumberFormatterMap[formatKey] = numberFormatter;
                            }
                        }
                        return numberFormatter(value);
                    };
                    CpuSamplingUtilities.mainToolbar_OnAfterDomInsert = function () {
                        var toolbarContainer = document.getElementById("mainToolbar");
                        var toolbarContentWidth = 45;
                        var toolbarContainerChildren = toolbarContainer.children;
                        for (var x = 0; x < toolbarContainerChildren.length; x++) {
                            toolbarContentWidth += toolbarContainerChildren.item(x).offsetWidth;
                        }
                        var limitedSpaceListener = function (mql) {
                            if (mql.matches) {
                                toolbarContainer.classList.add("limitedSpace");
                            }
                            else {
                                toolbarContainer.classList.remove("limitedSpace");
                            }
                        };
                        var limitedSpaceMediaQuery = window.matchMedia(DiagnosticsHub.Utilities.formatString("(max-width: {0}px)", toolbarContentWidth.toString()));
                        limitedSpaceListener(limitedSpaceMediaQuery);
                        limitedSpaceMediaQuery.addListener(limitedSpaceListener);
                    };
                    CpuSamplingUtilities.NumberFormatterMap = {};
                    CpuSamplingUtilities.Initialize = (function () {
                        Microsoft.Plugin.Culture.addEventListener("culturechanged", function () { return CpuSamplingUtilities.NumberFormatterMap = {}; });
                    })();
                    return CpuSamplingUtilities;
                }());
                CpuUsage.CpuSamplingUtilities = CpuSamplingUtilities;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallTreeClipboardFormatter = (function () {
                    function CallTreeClipboardFormatter() {
                    }
                    CallTreeClipboardFormatter.formatSelection = function (selectedIndexes, treeAsArray) {
                        var minDepth = selectedIndexes
                            .map(function (rowIndex) { return treeAsArray[rowIndex].depth; })
                            .reduce(function (previous, current) { return Math.min(previous, current); });
                        var formattedSelection = CallTreeClipboardFormatter.formatHeader();
                        var previousIndex = -1;
                        selectedIndexes.forEach(function (rowIndex) {
                            formattedSelection += CallTreeClipboardFormatter.NewLine;
                            if (previousIndex !== -1 && previousIndex + 1 !== rowIndex) {
                                formattedSelection += "[...]" + CallTreeClipboardFormatter.NewLine;
                            }
                            formattedSelection += CallTreeClipboardFormatter.formatRow(treeAsArray[rowIndex], minDepth);
                            previousIndex = rowIndex;
                        });
                        return formattedSelection;
                    };
                    CallTreeClipboardFormatter.formatHeader = function () {
                        var headerText = "";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_FunctionNameCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_TotalSamplesCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_TotalPercentCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_SelfSamplesCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_SelfPercentCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_ModuleCopyText");
                        return headerText;
                    };
                    CallTreeClipboardFormatter.formatRow = function (row, shallowestDepth) {
                        var rowText = "";
                        for (var depth = shallowestDepth; depth < row.depth; ++depth) {
                            rowText += "|";
                        }
                        if (!row.expandable) {
                            rowText += "   ";
                        }
                        else if (row.expanded()) {
                            rowText += " - ";
                        }
                        else {
                            rowText += " + ";
                        }
                        if (row.label && row.name) {
                            rowText += row.label + " " + row.name + "\t";
                        }
                        else if (row.label) {
                            rowText += row.label + "\t";
                        }
                        else {
                            rowText += row.name + "\t";
                        }
                        rowText += row.inclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.inclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.exclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.exclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.moduleName;
                        return rowText;
                    };
                    CallTreeClipboardFormatter.NewLine = "\r\n";
                    return CallTreeClipboardFormatter;
                }());
                CpuUsage.CallTreeClipboardFormatter = CallTreeClipboardFormatter;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var _cpuToolMarshalerProxy = null;
                var CpuToolPortMarshaler = (function () {
                    function CpuToolPortMarshaler() {
                        if (_cpuToolMarshalerProxy === null) {
                            _cpuToolMarshalerProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.Tools.CpuSampling.CpuToolMarshaler", {}, true);
                        }
                        this._contextChangedEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.ContextChangedEvent");
                        this._viewVisibilityChangedEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.ViewVisibilityChangedEvent");
                        this._resultStatusUpdatedEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.ResultStatusUpdatedEvent");
                        this._enabledTimeRangesChangedEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.EnabledTimeRangesChangedEvent");
                        this._threadSelectionChangedEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.ThreadSelectionChangedEvent");
                        this._collectionEnabledEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.CollectionEnabled");
                        this._collectionDisabledEvent = new DiagnosticsHub.ObservableEvent(_cpuToolMarshalerProxy, "CpuTool.CollectionDisabled");
                    }
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "contextChangedEvent", {
                        get: function () {
                            return this._contextChangedEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "viewVisibilityChangedEvent", {
                        get: function () {
                            return this._viewVisibilityChangedEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "resultStatusUpdatedEvent", {
                        get: function () {
                            return this._resultStatusUpdatedEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "enabledTimeRangesChangedEvent", {
                        get: function () {
                            return this._enabledTimeRangesChangedEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "threadSelectionChangedEvent", {
                        get: function () {
                            return this._threadSelectionChangedEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "collectionEnabledEvent", {
                        get: function () {
                            return this._collectionEnabledEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CpuToolPortMarshaler.prototype, "collectionDisabledEvent", {
                        get: function () {
                            return this._collectionDisabledEvent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    CpuToolPortMarshaler.prototype.getCurrentContext = function () {
                        return _cpuToolMarshalerProxy._call("getCurrentContext");
                    };
                    CpuToolPortMarshaler.prototype.getCurrentResultStatus = function () {
                        return _cpuToolMarshalerProxy._call("getCurrentResultStatus");
                    };
                    CpuToolPortMarshaler.prototype.raiseContextChangedEvent = function (args) {
                        return _cpuToolMarshalerProxy._call("raiseContextChangedEvent", args);
                    };
                    CpuToolPortMarshaler.prototype.raiseViewVisibilityChangedEvent = function (args) {
                        return _cpuToolMarshalerProxy._call("raiseViewVisibilityChangedEvent", args);
                    };
                    CpuToolPortMarshaler.prototype.raiseThreadSelectionChangedEvent = function (args) {
                        return _cpuToolMarshalerProxy._call("raiseThreadSelectionChangedEvent", args);
                    };
                    CpuToolPortMarshaler.prototype.tryCancelResult = function (taskId) {
                        return _cpuToolMarshalerProxy._call("tryCancelResult", taskId);
                    };
                    CpuToolPortMarshaler.prototype.breakAll = function () {
                        return _cpuToolMarshalerProxy._call("invokeBreakAll");
                    };
                    CpuToolPortMarshaler.prototype.isToolEnabled = function () {
                        return _cpuToolMarshalerProxy._call("isToolEnabled");
                    };
                    CpuToolPortMarshaler.prototype.getDoubleClickTimeMs = function () {
                        return _cpuToolMarshalerProxy._call("getDoubleClickTimeMs");
                    };
                    CpuToolPortMarshaler.prototype.loadTemplate = function (templateName) {
                        return _cpuToolMarshalerProxy._call("loadHtmlTemplate", templateName)
                            .then(function (templateSource) {
                            var templateElement = document.createElement("script");
                            templateElement.id = templateName;
                            templateElement.innerHTML = templateSource;
                            templateElement.type = "text/html";
                            document.head.appendChild(templateElement);
                        });
                    };
                    CpuToolPortMarshaler.prototype.setCollectionEnabled = function (enabled) {
                        return _cpuToolMarshalerProxy._call("setCollectionEnabled", enabled);
                    };
                    CpuToolPortMarshaler.prototype.getColumnConfig = function (templateName) {
                        return _cpuToolMarshalerProxy._call("getColumnConfig", templateName);
                    };
                    CpuToolPortMarshaler.prototype.onColumnChanged = function (templateName, column) {
                        return _cpuToolMarshalerProxy._call("onColumnChanged", templateName, column);
                    };
                    CpuToolPortMarshaler.prototype.showSplitViewToolWindow = function () {
                        return _cpuToolMarshalerProxy._call("showSplitViewToolWindow");
                    };
                    CpuToolPortMarshaler.prototype.isToolEnabledForTimespan = function (timerange) {
                        return _cpuToolMarshalerProxy._call("isToolEnabledForTimespan", { begin: timerange.begin.jsonValue, end: timerange.end.jsonValue });
                    };
                    CpuToolPortMarshaler.prototype.isToolSupported = function () {
                        return _cpuToolMarshalerProxy._call("isToolSupported");
                    };
                    return CpuToolPortMarshaler;
                }());
                CpuUsage.CpuToolPortMarshaler = CpuToolPortMarshaler;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var FunctionRowViewModel = (function () {
                    function FunctionRowViewModel(parent, dto) {
                        this._selected = ko.observable(false);
                        this._expanded = ko.observable(false);
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._dto = dto;
                        this._parent = parent;
                        this._children = ko.observableArray([]);
                        this._tooltip = this.evaluateTooltip();
                    }
                    Object.defineProperty(FunctionRowViewModel.prototype, "templateName", {
                        get: function () {
                            return "FunctionRowView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "id", {
                        get: function () {
                            return this._dto.id;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "name", {
                        get: function () {
                            return this._dto.name;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "nameTooltip", {
                        get: function () {
                            return this._tooltip;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "label", {
                        get: function () {
                            switch (this._dto.jmcState) {
                                case CpuUsage.JmcState.SystemCode:
                                    return Microsoft.Plugin.Resources.getString("SystemCallLabel");
                                case CpuUsage.JmcState.LibraryCode:
                                    return Microsoft.Plugin.Resources.getString("ExternalCallLabel");
                                default:
                                    return "";
                            }
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "moduleName", {
                        get: function () {
                            if (this._dto.aggType && this._dto.aggType !== CpuUsage.AggregateType.Unknown) {
                                return Microsoft.Plugin.Resources.getString("MultipleModuleLabel");
                            }
                            if (this._dto.rtModule) {
                                return Microsoft.Plugin.Resources.getString("DotNetNativeBuildTimeAndRuntimeModuleFormat", this._dto.moduleName, this._dto.rtModule);
                            }
                            return this._dto.moduleName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "inclusiveSamples", {
                        get: function () {
                            return this._dto.iSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "exclusiveSamples", {
                        get: function () {
                            return this._dto.eSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "inclusivePercent", {
                        get: function () {
                            return this._dto.iPercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "exclusivePercent", {
                        get: function () {
                            return this._dto.ePercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "scaledInclusivePercentage", {
                        get: function () {
                            if (this._parent.maxInclusiveSamples === 0) {
                                return 0;
                            }
                            return (this._dto.iSamples / this._parent.maxInclusiveSamples) * 100;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "scaledExclusivePercentage", {
                        get: function () {
                            if (this._parent.maxExclusiveSamples === 0) {
                                return 0;
                            }
                            return (this._dto.eSamples / this._parent.maxExclusiveSamples) * 100;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "fileName", {
                        get: function () {
                            return this._dto.fileName || null;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "lineNumber", {
                        get: function () {
                            return (typeof this._dto.lineNumber === "number") ? this._dto.lineNumber : null;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "selected", {
                        get: function () {
                            return this._selected;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "expanded", {
                        get: function () {
                            return this._expanded;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FunctionRowViewModel.prototype, "children", {
                        get: function () {
                            return this._children;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    FunctionRowViewModel.prototype.invoke = function () {
                        var _this = this;
                        this._cpuToolMarshaler.getCurrentContext()
                            .then(function (previousToolContext) {
                            var currentToolContext = {
                                viewContextSelectionAddress: _this._dto.address
                            };
                            return _this._cpuToolMarshaler.raiseContextChangedEvent({
                                previousContext: previousToolContext,
                                currentContext: currentToolContext,
                                sender: CpuUsage.ContextChangedSender.FlatFunctionsView
                            });
                        })
                            .done(function () { return _this._cpuToolMarshaler.showSplitViewToolWindow(); });
                    };
                    FunctionRowViewModel.prototype.goToToolWindow = function (viewModel, event) {
                        viewModel.invoke();
                        return false;
                    };
                    FunctionRowViewModel.prototype.getIdPath = function () {
                        return [this.id, this._parent.id];
                    };
                    FunctionRowViewModel.prototype.evaluateTooltip = function () {
                        var isExternalCode = this._dto.jmcState && (this._dto.jmcState === CpuUsage.JmcState.SystemCode || this._dto.jmcState === CpuUsage.JmcState.LibraryCode);
                        if (!isExternalCode) {
                            return this._dto.name;
                        }
                        var toolTipParts = [];
                        toolTipParts.push(this._dto.name);
                        toolTipParts.push(Microsoft.Plugin.Resources.getString("CalledFromNFunctionsInUserCode", this._dto.callerCount));
                        if (this._dto.aggType !== CpuUsage.AggregateType.Unknown) {
                            toolTipParts.push(Microsoft.Plugin.Resources.getString("ExclusiveSamplesAggregatedFromCallees"));
                        }
                        return toolTipParts.join("\r\n");
                    };
                    return FunctionRowViewModel;
                }());
                CpuUsage.FunctionRowViewModel = FunctionRowViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var EmptyRowViewModel = (function () {
                    function EmptyRowViewModel(id, textKey) {
                        this._selected = ko.observable(false);
                        this._expanded = ko.observable(false);
                        this._children = ko.observableArray([]);
                        this._id = id;
                        this._textKey = textKey;
                    }
                    Object.defineProperty(EmptyRowViewModel.prototype, "templateName", {
                        get: function () {
                            return "EmptyRowView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EmptyRowViewModel.prototype, "textKey", {
                        get: function () {
                            return this._textKey;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EmptyRowViewModel.prototype, "id", {
                        get: function () {
                            return this._id;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EmptyRowViewModel.prototype, "selected", {
                        get: function () {
                            return this._selected;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EmptyRowViewModel.prototype, "expanded", {
                        get: function () {
                            return this._expanded;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EmptyRowViewModel.prototype, "children", {
                        get: function () {
                            return this._children;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    EmptyRowViewModel.prototype.invoke = function () {
                    };
                    return EmptyRowViewModel;
                }());
                CpuUsage.EmptyRowViewModel = EmptyRowViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var ProcessRowViewModel = (function () {
                    function ProcessRowViewModel(dto) {
                        var _this = this;
                        this._selected = ko.observable(false);
                        this._expanded = ko.observable(true);
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._dto = dto;
                        if (this._dto.children.length > 0) {
                            this._children = ko.observableArray(this._dto.children.map(function (value) { return new CpuUsage.FunctionRowViewModel(_this, value); }));
                        }
                        else {
                            var messageKey = this._dto.iSamples > 0 ? "NoUserCodeMessage" : "NoCodeRunningMessage";
                            this._children = ko.observableArray([new CpuUsage.EmptyRowViewModel(0, messageKey)]);
                        }
                    }
                    Object.defineProperty(ProcessRowViewModel.prototype, "templateName", {
                        get: function () {
                            return "ProcessRowView";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "id", {
                        get: function () {
                            return this._dto.id;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "name", {
                        get: function () {
                            return Microsoft.Plugin.Resources.getString("ProcessRowNameFormat", this._dto.moduleName, this._dto.id);
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "moduleName", {
                        get: function () {
                            return this._dto.moduleName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "inclusiveSamples", {
                        get: function () {
                            return this._dto.iSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "exclusiveSamples", {
                        get: function () {
                            return this._dto.eSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "inclusivePercent", {
                        get: function () {
                            return this._dto.iPercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "exclusivePercent", {
                        get: function () {
                            return this._dto.ePercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "maxInclusiveSamples", {
                        get: function () {
                            return this._dto.iSamplesMax;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "maxExclusiveSamples", {
                        get: function () {
                            return this._dto.eSamplesMax;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "childCount", {
                        get: function () {
                            return this._dto.childrenCount;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "selected", {
                        get: function () {
                            return this._selected;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "expanded", {
                        get: function () {
                            return this._expanded;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ProcessRowViewModel.prototype, "children", {
                        get: function () {
                            return this._children;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    ProcessRowViewModel.prototype.invoke = function () {
                        var _this = this;
                        this._cpuToolMarshaler.getCurrentContext()
                            .then(function (previousToolContext) {
                            return _this._cpuToolMarshaler.raiseContextChangedEvent({
                                previousContext: previousToolContext,
                                currentContext: {},
                                sender: CpuUsage.ContextChangedSender.FlatFunctionsView
                            });
                        })
                            .done(function () { return _this._cpuToolMarshaler.showSplitViewToolWindow(); });
                    };
                    ProcessRowViewModel.prototype.onClick = function (viewModel, evt) {
                        viewModel.invoke();
                        return false;
                    };
                    ProcessRowViewModel.prototype.getIdPath = function () {
                        return [this.id];
                    };
                    return ProcessRowViewModel;
                }());
                CpuUsage.ProcessRowViewModel = ProcessRowViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var FlatFunctionsClipboardFormatter = (function () {
                    function FlatFunctionsClipboardFormatter() {
                    }
                    FlatFunctionsClipboardFormatter.formatSelection = function (selection) {
                        var formattedSelection = FlatFunctionsClipboardFormatter.formatHeader();
                        selection.forEach(function (row) {
                            formattedSelection += FlatFunctionsClipboardFormatter.NewLine;
                            if (row instanceof CpuUsage.ProcessRowViewModel) {
                                formattedSelection += FlatFunctionsClipboardFormatter.formatProcessRow(row);
                            }
                            else if (row instanceof CpuUsage.FunctionRowViewModel) {
                                formattedSelection += FlatFunctionsClipboardFormatter.formatFunctionRow(row);
                            }
                            else {
                                DiagnosticsHub.getLogger().error("Unknown row type in flat functions view");
                            }
                        });
                        return formattedSelection;
                    };
                    FlatFunctionsClipboardFormatter.formatHeader = function () {
                        var headerText = "";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_FunctionNameCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_TotalSamplesCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_TotalPercentCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_SelfSamplesCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_SelfPercentCopyText") + "\t";
                        headerText += Microsoft.Plugin.Resources.getString("CpuUsageTreeGrid_ModuleCopyText");
                        return headerText;
                    };
                    FlatFunctionsClipboardFormatter.formatProcessRow = function (row) {
                        var rowText = "";
                        rowText += row.name + "\t";
                        rowText += row.inclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.inclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.exclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.exclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.moduleName;
                        return rowText;
                    };
                    FlatFunctionsClipboardFormatter.formatFunctionRow = function (row) {
                        var rowText = "  ";
                        if (row.label && row.name) {
                            rowText += row.label + " " + row.name + "\t";
                        }
                        else if (row.label) {
                            rowText += row.label + "\t";
                        }
                        else {
                            rowText += row.name + "\t";
                        }
                        rowText += row.inclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.inclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.exclusiveSamples + "\t";
                        rowText += CpuUsage.CpuSamplingUtilities.localizeNumber(row.exclusivePercent, { style: "percent", minimumFractionDigits: 2 }) + "\t";
                        rowText += row.moduleName;
                        return rowText;
                    };
                    FlatFunctionsClipboardFormatter.NewLine = "\r\n";
                    return FlatFunctionsClipboardFormatter;
                }());
                CpuUsage.FlatFunctionsClipboardFormatter = FlatFunctionsClipboardFormatter;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
ko.bindingHandlers["focus"] = {
    previousElement: null,
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var onFocus = function () {
            if (ko.bindingHandlers["focus"].previousElement && ko.bindingHandlers["focus"].previousElement !== element) {
                var e = document.createEvent("Event");
                e.initEvent("blur", false, false);
                ko.bindingHandlers["focus"].previousElement.dispatchEvent(e);
            }
            var hasFocusObservable = valueAccessor();
            if (ko.isWriteableObservable(hasFocusObservable) && !hasFocusObservable()) {
                hasFocusObservable(true);
            }
            ko.bindingHandlers["focus"].previousElement = element;
        };
        var onBlur = function () {
            var hasFocusObservable = valueAccessor();
            if (ko.isWriteableObservable(hasFocusObservable) && !!hasFocusObservable()) {
                hasFocusObservable(false);
            }
        };
        element.addEventListener("focus", onFocus);
        element.addEventListener("blur", onBlur);
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        if (!ko.unwrap(valueAccessor())) {
            element.blur();
        }
        else {
            element.focus();
        }
    }
};
ko.bindingHandlers["localizedNumber"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var valueWithFormat = valueAccessor();
        var value = ko.unwrap(valueWithFormat.value);
        var localizedText = value.toLocaleString(Microsoft.Plugin.Culture.formatRegion, valueWithFormat.options);
        ko.utils.setTextContent(element, localizedText);
    }
};
ko.virtualElements.allowedBindings["localizedNumber"] = true;
ko.bindingHandlers["localizedText"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var keyWithArgs = valueAccessor();
        if (!Array.isArray(keyWithArgs)) {
            keyWithArgs = [keyWithArgs];
        }
        var unwrappedArgs = keyWithArgs.map(function (value) { return ko.unwrap(value); });
        var localizedText = Microsoft.Plugin.Resources.getString.apply(null, unwrappedArgs);
        ko.utils.setHtml(element, localizedText);
    }
};
ko.bindingHandlers["localizedAriaLabel"] = {
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var stringKey = ko.unwrap(valueAccessor());
        var localizedText = Microsoft.Plugin.Resources.getString(stringKey);
        element.setAttribute("aria-label", localizedText);
    }
};
ko.bindingHandlers["svgImage"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var svgKey = ko.unwrap(valueAccessor());
        element.appendChild(Microsoft.VisualStudio.DiagnosticsHub.Utilities.getSVGPlaceHolder(svgKey));
        Microsoft.Plugin.Theme.processInjectedSvg(element);
    }
};
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var _cpuToolTelemetryProxy = null;
                var CpuToolTelemetryPortMarshaler = (function () {
                    function CpuToolTelemetryPortMarshaler() {
                        this._telemetryCpuUsage = new DiagnosticsHub.Telemetry.CpuUsage();
                        this._isSetCreateDetailedReport = false;
                        this._isSetSearchIsUsed = false;
                        this._isSetSearchOptionsChanged = false;
                        if (_cpuToolTelemetryProxy === null) {
                            _cpuToolTelemetryProxy = Microsoft.Plugin.Utilities.JSONMarshaler.attachToPublishedObject("Microsoft.DiagnosticsHub.Tools.CpuSampling.VisualStudio.CpuToolTelemetryMarshaler", {}, true);
                        }
                    }
                    CpuToolTelemetryPortMarshaler.prototype.filterViewOpen = function () {
                        _cpuToolTelemetryProxy._post("cpuUsageReportFilterViewOpen");
                    };
                    CpuToolTelemetryPortMarshaler.prototype.createDetailedReport = function () {
                        if (!this._isSetCreateDetailedReport) {
                            this._isSetCreateDetailedReport = true;
                            _cpuToolTelemetryProxy._post("cpuUsageReportCreateDetailedReport");
                        }
                    };
                    CpuToolTelemetryPortMarshaler.prototype.searchIsUsed = function () {
                        if (!this._isSetSearchIsUsed) {
                            this._isSetSearchIsUsed = true;
                            _cpuToolTelemetryProxy._post("cpuUsageReportSearchIsUsed");
                        }
                    };
                    CpuToolTelemetryPortMarshaler.prototype.searchOptionsChanged = function () {
                        if (!this._isSetSearchOptionsChanged) {
                            this._isSetSearchOptionsChanged = true;
                            _cpuToolTelemetryProxy._post("cpuUsageReportSearchOptionsChanged");
                        }
                    };
                    CpuToolTelemetryPortMarshaler.prototype.breakAllInvoked = function (success) {
                        _cpuToolTelemetryProxy._post("cpuUsageInvokeBreakAll", success);
                    };
                    CpuToolTelemetryPortMarshaler.prototype.enabledToggle = function (state) {
                        _cpuToolTelemetryProxy._post("cpuUsageEnabledToggle", state);
                    };
                    CpuToolTelemetryPortMarshaler.prototype.mouseDown = function (viewId) {
                        _cpuToolTelemetryProxy._post("cpuUsageMouseDown", viewId);
                    };
                    CpuToolTelemetryPortMarshaler.prototype.jmcToggled = function (state) {
                        this._telemetryCpuUsage.jmcToggle(state);
                    };
                    CpuToolTelemetryPortMarshaler.prototype.enabledAtStart = function (state) {
                        this._telemetryCpuUsage.enabledAtStart(state);
                    };
                    return CpuToolTelemetryPortMarshaler;
                }());
                CpuUsage.CpuToolTelemetryPortMarshaler = CpuToolTelemetryPortMarshaler;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                (function (ThreadRoles) {
                    ThreadRoles[ThreadRoles["Unknown"] = 0] = "Unknown";
                    ThreadRoles[ThreadRoles["UIThread"] = 1] = "UIThread";
                    ThreadRoles[ThreadRoles["GCThread"] = 256] = "GCThread";
                })(CpuUsage.ThreadRoles || (CpuUsage.ThreadRoles = {}));
                var ThreadRoles = CpuUsage.ThreadRoles;
                var ThreadViewModel = (function () {
                    function ThreadViewModel(threadInfo, checked) {
                        this._threadId = threadInfo.tid;
                        this._threadRole = threadInfo.roles;
                        this._commitedIsChecked = checked;
                        this._isChecked = ko.observable(checked);
                        this._sampleCount = ko.observable(threadInfo.sampleCount);
                        this._sampleFractionOfProcess = ko.observable(threadInfo.sampleFractionOfProcess);
                        this._label = ko.pureComputed(this.computeLabel, this);
                        this._tooltip = ko.pureComputed(this.computeTooltip, this);
                        this._hasFocus = ko.observable(false);
                    }
                    Object.defineProperty(ThreadViewModel.prototype, "isChecked", {
                        get: function () {
                            return this._isChecked;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "hasFocus", {
                        get: function () {
                            return this._hasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "label", {
                        get: function () {
                            return this._label;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "tooltip", {
                        get: function () {
                            return this._tooltip;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "threadRole", {
                        get: function () {
                            return this._threadRole;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "sampleCount", {
                        get: function () {
                            return this._sampleCount;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "sampleFractionOfProcess", {
                        get: function () {
                            return this._sampleFractionOfProcess;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadViewModel.prototype, "threadId", {
                        get: function () {
                            return this._threadId;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    ThreadViewModel.prototype.commitCheck = function () {
                        this._commitedIsChecked = this.isChecked();
                    };
                    ThreadViewModel.prototype.rollbackCheck = function () {
                        this.isChecked(this._commitedIsChecked);
                    };
                    ThreadViewModel.prototype.updateThread = function (threadInfo) {
                        if (threadInfo.tid !== this.threadId) {
                            return;
                        }
                        this.sampleCount(threadInfo.sampleCount);
                        this.sampleFractionOfProcess(threadInfo.sampleFractionOfProcess);
                    };
                    ThreadViewModel.prototype.computeLabel = function () {
                        var resourceId = "ThreadsSelection";
                        if (this.sampleCount() > 0 && this.sampleFractionOfProcess() < ThreadViewModel.ThreadSamplesThreshold) {
                            resourceId += "_LessThan";
                        }
                        if ((this.threadRole & ThreadRoles.UIThread) !== 0) {
                            resourceId += "_UIRole";
                        }
                        return Microsoft.Plugin.Resources.getString(resourceId, this.threadId, this.computeFormattedSamplePercent());
                    };
                    ThreadViewModel.prototype.computeTooltip = function () {
                        var toolTipParts = [];
                        toolTipParts.push(Microsoft.Plugin.Resources.getString("ThreadsSelection_Thread", this.threadId));
                        if ((this.threadRole & ThreadRoles.UIThread) !== 0) {
                            toolTipParts.push(Microsoft.Plugin.Resources.getString("UIThreadRole"));
                        }
                        toolTipParts.push(Microsoft.Plugin.Resources.getString("SamplePercentOfProcessLabel", this.computeFormattedSamplePercent()));
                        toolTipParts.push(Microsoft.Plugin.Resources.getString("SampleCountLabel", this.sampleCount()));
                        return toolTipParts.join("\r\n");
                    };
                    ThreadViewModel.prototype.computeFormattedSamplePercent = function () {
                        var samplePercent;
                        if (this.sampleCount() === 0) {
                            samplePercent = CpuUsage.CpuSamplingUtilities.localizeNumber(this.sampleFractionOfProcess(), { style: "percent", minimumFractionDigits: 0 });
                        }
                        else if (this.sampleFractionOfProcess() < ThreadViewModel.ThreadSamplesThreshold) {
                            samplePercent = CpuUsage.CpuSamplingUtilities.localizeNumber(ThreadViewModel.ThreadSamplesThreshold, { style: "percent", minimumFractionDigits: 1 });
                        }
                        else {
                            samplePercent = CpuUsage.CpuSamplingUtilities.localizeNumber(this.sampleFractionOfProcess(), { style: "percent", minimumFractionDigits: 1 });
                        }
                        return samplePercent;
                    };
                    ThreadViewModel.ThreadSamplesThreshold = 0.001;
                    return ThreadViewModel;
                }());
                CpuUsage.ThreadViewModel = ThreadViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var ThreadFilterViewModel = (function () {
                    function ThreadFilterViewModel(dataWarehouse) {
                        var _this = this;
                        this._isDefault = ko.observable(true);
                        this._threads = ko.observableArray([]);
                        this._isDisabled = ko.observable(true);
                        this._timeDomain = ko.observable(null);
                        this._threadDomain = ko.observableArray([]);
                        this._selectAll = ko.observable(true);
                        this._selectAllHasFocus = ko.observable(false);
                        this._showExternalCode = ko.observable(false);
                        this._showExternalCodeHasFocus = ko.observable(false);
                        this._filterVisible = ko.observable(false);
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._dataLoadStatus = ko.observable(CpuUsage.DataLoadEvent.DataLoadCompleted);
                        this._committedShowExternalCode = ko.observable(false);
                        this._threadContext = ko.pureComputed(function () { return _this.computeContext(); });
                        this._onJmcChangedBoundFunction = this.onJmcChanged.bind(this);
                        this._currentFocusedIndex = null;
                        this._progress = new DiagnosticsHub.ProgressViewModel(Microsoft.Plugin.Resources.getString("PreparingThreadsProgressTaskName"), 1);
                        this._telemetry = new CpuUsage.CpuToolTelemetryPortMarshaler();
                        this._timeDomain.equalityComparer = CpuUsage.CpuSamplingUtilities.areTimespansEqual;
                        this._selectAllSubscription = this.selectAll.subscribe(this.onSelectAll.bind(this));
                        this._progress.cancellationRequestedEvent.addEventListener(function () { return _this.dataLoadPromise.cancel(); });
                        this._dataWarehouse = dataWarehouse;
                        this._viewEventManager = DiagnosticsHub.getViewEventManager();
                        this._viewEventManager.jmcEnabledStateChanged.addEventListener(this._onJmcChangedBoundFunction);
                        this._threadContext.subscribe(function (context) { return _this.onContextChanged(context); });
                        this._applyButtonStatus = ko.computed(function () {
                            if (!_this.threads) {
                                return false;
                            }
                            return _this.threads()
                                .some(function (value) {
                                return value.isChecked();
                            });
                        });
                        this._isDisabled.subscribe(function (isDisabled) {
                            if (isDisabled) {
                                _this.rollbackChanges();
                                _this.filterVisible(false);
                            }
                        });
                        this._threadDomain.subscribe(function (threadDomain) {
                            _this._cpuToolMarshaler.raiseThreadSelectionChangedEvent({
                                currentThreadDomain: threadDomain,
                                threadDomainPreparationStatus: CpuUsage.ResultPreparationStatus.Completed
                            });
                        });
                        this._dataWarehouse.getJmcService().getJmcEnabledState().then(function (jmcState) {
                            _this.onJmcChanged({
                                currEnabledState: jmcState,
                                prevEnabledState: _this._committedShowExternalCode()
                            });
                        });
                    }
                    Object.defineProperty(ThreadFilterViewModel.prototype, "dataLoadPromise", {
                        get: function () {
                            return !this._dataLoadPromise ?
                                Microsoft.Plugin.Promise.as(void (0)) : this._dataLoadPromise;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "dataLoadStatus", {
                        get: function () {
                            return this._dataLoadStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "timeDomain", {
                        get: function () {
                            return this._timeDomain;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "threads", {
                        get: function () {
                            return this._threads;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "threadDomain", {
                        get: function () {
                            return this._threadDomain;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "showExternalCode", {
                        get: function () {
                            return this._showExternalCode;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "showExternalCodeHasFocus", {
                        get: function () {
                            return this._showExternalCodeHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "isDefault", {
                        get: function () {
                            return this._isDefault;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "isDisabled", {
                        get: function () {
                            return this._isDisabled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "selectAll", {
                        get: function () {
                            return this._selectAll;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "selectAllHasFocus", {
                        get: function () {
                            return this._selectAllHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "filterVisible", {
                        get: function () {
                            return this._filterVisible;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "applyButtonStatus", {
                        get: function () {
                            return this._applyButtonStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ThreadFilterViewModel.prototype, "progress", {
                        get: function () {
                            return this._progress;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    ThreadFilterViewModel.prototype.dispose = function () {
                        this._viewEventManager.jmcEnabledStateChanged.removeEventListener(this._onJmcChangedBoundFunction);
                        this._selectAllSubscription.dispose();
                    };
                    ThreadFilterViewModel.prototype.onAfterDomInsert = function (elements, viewModel) {
                        var element = elements[0];
                        var dropDownFlyout = DiagnosticsHub.Utilities.findChildById(element, "threadFlyout");
                        var filterList = DiagnosticsHub.Utilities.findChildById(element, "threadFilterList");
                        var updateControlHeight = function () {
                            var dropDownHeight = dropDownFlyout.offsetHeight - filterList.clientHeight;
                            var availableHeight = window.innerHeight - element.offsetHeight - element.offsetTop - dropDownHeight;
                            filterList.style.maxHeight = Math.min(availableHeight, 175) + "px";
                        };
                        var onThreadsUpdatedSubscription = viewModel.threads.subscribe(updateControlHeight);
                        var updateControlHeightBoundFunction = DiagnosticsHub.eventThrottler(updateControlHeight, DiagnosticsHub.Constants.WindowResizeThrottle);
                        window.addEventListener("resize", updateControlHeightBoundFunction);
                        ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                            window.removeEventListener("resize", updateControlHeightBoundFunction);
                            onThreadsUpdatedSubscription.dispose();
                        });
                    };
                    ThreadFilterViewModel.prototype.commitChanges = function () {
                        var _this = this;
                        this.threads().forEach(function (thread) { return thread.commitCheck(); });
                        var threadDomainNew = this._threads()
                            .filter(function (thread) { return thread.isChecked(); })
                            .map(function (thread) { return thread.threadId; });
                        var isDefaultNew = threadDomainNew.length === this._threads().length && !this.showExternalCode();
                        if (this.isDefault() !== isDefaultNew) {
                            this.isDefault(isDefaultNew);
                        }
                        var threadDomainChanged = false;
                        if (this._threadDomain().length !== threadDomainNew.length) {
                            threadDomainChanged = true;
                        }
                        else {
                            var threadDomainSorted = this._threadDomain().slice(0).sort();
                            var threadDomainNewSorted = threadDomainNew.slice(0).sort();
                            for (var i = 0; i < threadDomainSorted.length; i++) {
                                if (threadDomainSorted[i] !== threadDomainNewSorted[i]) {
                                    threadDomainChanged = true;
                                    break;
                                }
                            }
                        }
                        if (threadDomainChanged) {
                            this._threadDomain(threadDomainNew);
                        }
                        if (this._committedShowExternalCode() !== this.showExternalCode()) {
                            this._telemetry.jmcToggled(!this.showExternalCode());
                            this._dataWarehouse.getJmcService().setJmcEnabledState(!this.showExternalCode());
                        }
                        this._selectAllSubscription.dispose();
                        this.selectAll(threadDomainNew.length === this._threads().length);
                        ko.tasks.schedule(function () { return _this._selectAllSubscription = _this.selectAll.subscribe(_this.onSelectAll.bind(_this)); });
                        this.filterVisible(false);
                    };
                    ThreadFilterViewModel.prototype.rollbackChanges = function () {
                        this.showExternalCode(this._committedShowExternalCode());
                        this.threads().forEach(function (thread) { return thread.rollbackCheck(); });
                        this.filterVisible(false);
                    };
                    ThreadFilterViewModel.prototype.onContextChanged = function (context) {
                        var _this = this;
                        if (this._dataLoadPromise) {
                            this._dataLoadPromise.cancel();
                        }
                        this._progress.currentValue(0);
                        this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadStart);
                        this._cpuToolMarshaler.raiseThreadSelectionChangedEvent({
                            threadDomainPreparationStatus: CpuUsage.ResultPreparationStatus.InProgress
                        });
                        this._dataLoadPromise = Microsoft.Plugin.Promise.wrap(null)
                            .then(function () { return _this._dataWarehouse.getFilteredData(context, CpuUsage.Constants.cpuSamplingAnalyzer); }, null, function (progress) { return _this._progress.currentValue(progress.progressValue); })
                            .then(function (threads) { return _this.addThreads(threads); });
                        this._dataLoadPromise.done(function () {
                            _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCompleted);
                            _this._dataLoadPromise = null;
                        }, function (error) {
                            if (error.name === CpuUsage.Constants.errorNameCanceled) {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCanceled);
                                _this._cpuToolMarshaler.raiseThreadSelectionChangedEvent({
                                    threadDomainPreparationStatus: CpuUsage.ResultPreparationStatus.Canceled
                                });
                            }
                            else {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadFailed);
                                _this._cpuToolMarshaler.raiseThreadSelectionChangedEvent({
                                    threadDomainPreparationStatus: CpuUsage.ResultPreparationStatus.Failed
                                });
                            }
                            _this._dataLoadPromise = null;
                        });
                        return this._dataLoadPromise;
                    };
                    ThreadFilterViewModel.prototype.addThreads = function (threads) {
                        var _this = this;
                        var newThreadIds = [];
                        threads.forEach(function (thread) {
                            var existingThread = ko.utils.arrayFirst(_this._threads(), function (threadVM) {
                                return threadVM.threadId === thread.tid;
                            });
                            if (!existingThread) {
                                var newThread = new CpuUsage.ThreadViewModel(thread, _this.isDefault());
                                _this._threads.push(newThread);
                                if (newThread.isChecked) {
                                    newThreadIds.push(newThread.threadId);
                                }
                            }
                            else {
                                existingThread.updateThread(thread);
                            }
                        });
                        this._threadDomain.valueWillMutate();
                        if (newThreadIds.length > 0) {
                            this._threadDomain().push.apply(this._threadDomain(), newThreadIds);
                        }
                        this._threadDomain.valueHasMutated();
                        this._threads.sort(function (thread1, thread2) {
                            if (thread1.threadRole === CpuUsage.ThreadRoles.Unknown && thread2.threadRole !== CpuUsage.ThreadRoles.Unknown) {
                                return 1;
                            }
                            else if (thread1.threadRole !== CpuUsage.ThreadRoles.Unknown && thread2.threadRole === CpuUsage.ThreadRoles.Unknown) {
                                return -1;
                            }
                            else {
                                return thread2.sampleCount() - thread1.sampleCount();
                            }
                        });
                    };
                    ThreadFilterViewModel.prototype.onFocus = function () {
                        this._currentFocusedIndex = null;
                    };
                    ThreadFilterViewModel.prototype.onKeyDown = function (viewModel, event) {
                        if (DiagnosticsHub.Common.KeyCodes.ArrowUp === event.keyCode) {
                            this.updateFocusedThread(false);
                            if (this._currentFocusedIndex === null) {
                                this._currentFocusedIndex = this._threads().length - 1;
                            }
                            else if (this._currentFocusedIndex === 0) {
                                this._currentFocusedIndex = null;
                            }
                            else {
                                this._currentFocusedIndex = this._currentFocusedIndex - 1;
                            }
                            this.updateFocusedThread(true);
                            return false;
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.ArrowDown === event.keyCode) {
                            this.updateFocusedThread(false);
                            if (this._currentFocusedIndex === null) {
                                this._currentFocusedIndex = 0;
                            }
                            else if (this._currentFocusedIndex === this._threads().length - 1) {
                                this._currentFocusedIndex = null;
                            }
                            else {
                                this._currentFocusedIndex = this._currentFocusedIndex + 1;
                            }
                            this.updateFocusedThread(true);
                            return false;
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.Tab === event.keyCode && event.shiftKey) {
                            this._showExternalCodeHasFocus(true);
                            return false;
                        }
                        return true;
                    };
                    ThreadFilterViewModel.prototype.computeContext = function () {
                        this._committedShowExternalCode();
                        return {
                            timeDomain: this._timeDomain(),
                            customDomain: {
                                task: "get-threads",
                                includeZeroValued: "true"
                            }
                        };
                    };
                    ThreadFilterViewModel.prototype.updateFocusedThread = function (focus) {
                        if (this._currentFocusedIndex === null || this._currentFocusedIndex >= this._threads().length) {
                            this._selectAllHasFocus(focus);
                        }
                        else {
                            this._threads()[this._currentFocusedIndex].hasFocus(focus);
                        }
                    };
                    ThreadFilterViewModel.prototype.onSelectAll = function (selectAll) {
                        this._threads().forEach(function (thread) {
                            thread.isChecked(selectAll);
                        });
                    };
                    ThreadFilterViewModel.prototype.onJmcChanged = function (jmcChangedArgs) {
                        this._committedShowExternalCode(!jmcChangedArgs.currEnabledState);
                        this.showExternalCode(!jmcChangedArgs.currEnabledState);
                    };
                    ThreadFilterViewModel.prototype.onHeaderKeyDown = function (viewModel, e) {
                        if (this._isDisabled()) {
                            return true;
                        }
                        if (e.keyCode === DiagnosticsHub.Common.KeyCodes.ArrowDown) {
                            this.filterVisible(true);
                            this.showExternalCodeHasFocus(true);
                            return false;
                        }
                        else if (e.keyCode === DiagnosticsHub.Common.KeyCodes.Enter) {
                            return this.toggleFlyout(this, null);
                        }
                        return true;
                    };
                    ThreadFilterViewModel.prototype.toggleFlyout = function (viewModel, event) {
                        if (this._isDisabled()) {
                            return true;
                        }
                        var filterVisible = this.filterVisible();
                        if (filterVisible) {
                            this.rollbackChanges();
                        }
                        this.filterVisible(!filterVisible);
                        return false;
                    };
                    return ThreadFilterViewModel;
                }());
                CpuUsage.ThreadFilterViewModel = ThreadFilterViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var SearchControlViewModel = (function () {
                    function SearchControlViewModel(model, isEnabled) {
                        var _this = this;
                        this._showSettings = ko.observable(false);
                        this._searchInputHasFocus = ko.observable(false);
                        this._searchSubmitHasFocus = ko.observable(false);
                        this._isRegularExpression = ko.observable(false);
                        this._isRegularExpressionHasFocus = ko.observable(false);
                        this._isCaseSensitive = ko.observable(false);
                        this._isCaseSensitiveHasFocus = ko.observable(false);
                        this._searchTerm = ko.observable("");
                        this._autoCollapseTimeout = null;
                        this._isDisabled = ko.observable(false);
                        this._model = model;
                        var telemetry = new CpuUsage.CpuToolTelemetryPortMarshaler();
                        this._isRegularExpression.subscribe(function (newValue) {
                            window.clearTimeout(_this._autoCollapseTimeout);
                            _this._autoCollapseTimeout = window.setTimeout(function () { return _this.showSettings(false); }, SearchControlViewModel.autoCollapseTime);
                            telemetry.searchOptionsChanged();
                        });
                        this._isCaseSensitive.subscribe(function (newValue) {
                            window.clearTimeout(_this._autoCollapseTimeout);
                            _this._autoCollapseTimeout = window.setTimeout(function () { return _this.showSettings(false); }, SearchControlViewModel.autoCollapseTime);
                            telemetry.searchOptionsChanged();
                        });
                        this._showSettings.subscribe(function (visible) {
                            window.clearTimeout(_this._autoCollapseTimeout);
                            _this._autoCollapseTimeout = null;
                        });
                        this._hasFocus = ko.pureComputed(function () {
                            return !_this._isDisabled() && (_this._searchInputHasFocus() || _this._searchSubmitHasFocus());
                        });
                        this._isDisabled(!isEnabled);
                    }
                    Object.defineProperty(SearchControlViewModel.prototype, "showSettings", {
                        get: function () {
                            return this._showSettings;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "isDisabled", {
                        get: function () {
                            return this._isDisabled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "hasFocus", {
                        get: function () {
                            return this._hasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "searchInputHasFocus", {
                        get: function () {
                            return this._searchInputHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "searchSubmitHasFocus", {
                        get: function () {
                            return this._searchSubmitHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "isCaseSensitive", {
                        get: function () {
                            return this._isCaseSensitive;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "isCaseSensitiveHasFocus", {
                        get: function () {
                            return this._isCaseSensitiveHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "isRegularExpression", {
                        get: function () {
                            return this._isRegularExpression;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "isRegularExpressionHasFocus", {
                        get: function () {
                            return this._isRegularExpressionHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel.prototype, "searchTerm", {
                        get: function () {
                            return this._searchTerm;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(SearchControlViewModel, "autoCollapseTime", {
                        get: function () {
                            return 2000;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    SearchControlViewModel.prototype.onAfterDomInsert = function (elements, viewModel) {
                        var element = elements[0];
                        var onMouseDown = function (event) {
                            if (!viewModel.showSettings() || viewModel.isDisabled()) {
                                return;
                            }
                            if (!element.contains(event.target)) {
                                viewModel.showSettings(false);
                            }
                        };
                        var onKeyDown = function (event) {
                            if (event.keyCode === DiagnosticsHub.Common.KeyCodes.F3) {
                                viewModel.search();
                                event.preventDefault();
                            }
                        };
                        var onBlur = function (event) {
                            if (viewModel.showSettings() && !element.contains(document.activeElement)) {
                                viewModel.showSettings(false);
                            }
                        };
                        element.addEventListener("blur", onBlur, true);
                        window.addEventListener("keydown", onKeyDown);
                        window.addEventListener("mousedown", onMouseDown);
                        ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                            window.removeEventListener("keydown", onKeyDown);
                            window.removeEventListener("mousedown", onMouseDown);
                            element.removeEventListener("blur", onBlur);
                        });
                    };
                    SearchControlViewModel.prototype.search = function () {
                        if (this.isDisabled()) {
                            return;
                        }
                        this._model.search(this._searchTerm(), this._isCaseSensitive(), this._isRegularExpression());
                    };
                    SearchControlViewModel.prototype.onDropDownClick = function (viewModel, event) {
                        if (this.isDisabled()) {
                            return false;
                        }
                        this._showSettings(!this._showSettings());
                        return false;
                    };
                    SearchControlViewModel.prototype.onSearchBoxKeyDown = function (viewModel, event) {
                        if (this.isDisabled()) {
                            return true;
                        }
                        if (DiagnosticsHub.Common.KeyCodes.Enter === event.keyCode) {
                            this.search();
                            return false;
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.Escape === event.keyCode) {
                            this._searchTerm("");
                            return false;
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.ArrowDown === event.keyCode) {
                            this._showSettings(true);
                            this.isRegularExpressionHasFocus(true);
                            return false;
                        }
                        return true;
                    };
                    SearchControlViewModel.prototype.onFlyoutKeyDown = function (viewModel, event) {
                        if (DiagnosticsHub.Common.KeyCodes.ArrowUp === event.keyCode || DiagnosticsHub.Common.KeyCodes.ArrowDown === event.keyCode) {
                            var toggleFocus = this.isRegularExpressionHasFocus();
                            this.isRegularExpressionHasFocus(!toggleFocus);
                            this.isCaseSensitiveHasFocus(toggleFocus);
                            return false;
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.Escape === event.keyCode) {
                            this._showSettings(false);
                            return false;
                        }
                        return true;
                    };
                    return SearchControlViewModel;
                }());
                CpuUsage.SearchControlViewModel = SearchControlViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var TreeGridViewModel = (function () {
                    function TreeGridViewModel(dao, header) {
                        var _this = this;
                        this._roots = ko.observableArray([]);
                        this._treeAsArrayProjection = ko.pureComputed(function () { return _this.computeTreeAsArrayProjection(); });
                        this._selectedRows = ko.observableArray([]);
                        this._focusedRowIndex = ko.pureComputed(function () { return _this.computedFocusedRowIndex(); });
                        this._focusedRow = ko.pureComputed(function () { return _this.computeFocusedRow(); });
                        this._scrollTop = ko.observable(0);
                        this._clientHeight = ko.observable(0);
                        this._logger = DiagnosticsHub.getLogger();
                        this._automation = DiagnosticsHub.getAutomationManager(this._logger);
                        this._dataLoadStatus = ko.observable(CpuUsage.DataLoadEvent.DataLoadCompleted);
                        this._dao = dao;
                        this._header = header;
                        this._header.sortInfo.subscribe(this.onSortChanged.bind(this));
                        this._selectedRows.subscribe(this.onSelectionChanged.bind(this), null, "arrayChange");
                    }
                    Object.defineProperty(TreeGridViewModel.prototype, "dataLoadPromise", {
                        get: function () {
                            return !this._dataLoadPromise ?
                                Microsoft.Plugin.Promise.as(void (0)) : this._dataLoadPromise;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "roots", {
                        get: function () {
                            return this._roots;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "treeAsArray", {
                        get: function () {
                            return this._treeAsArrayProjection;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "selectedRows", {
                        get: function () {
                            return this._selectedRows;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "header", {
                        get: function () {
                            return this._header;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "scrollTop", {
                        get: function () {
                            return this._scrollTop;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "clientHeight", {
                        get: function () {
                            return this._clientHeight;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "dataLoadStatus", {
                        get: function () {
                            return this._dataLoadStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "focusedRowIndex", {
                        get: function () {
                            return this._focusedRowIndex;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridViewModel.prototype, "focusedRow", {
                        get: function () {
                            return this._focusedRow;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    TreeGridViewModel.prototype.onAfterDomInsert = function (elements, viewModel) {
                        var element = elements[0];
                        var header = element.querySelector(".treeGridHeader");
                        var body = element.querySelector(".treeGridBody");
                        viewModel._header.onAfterDomInsert(header, body);
                        var updateCachedSizes = function () {
                            viewModel._scrollTop(body.scrollTop);
                            viewModel._clientHeight(body.clientHeight);
                        };
                        updateCachedSizes();
                        var onResizeBoundFunction = DiagnosticsHub.eventThrottler(updateCachedSizes, DiagnosticsHub.Constants.WindowResizeThrottle);
                        body.addEventListener("scroll", updateCachedSizes);
                        window.addEventListener("resize", onResizeBoundFunction);
                        ko.utils.domNodeDisposal.addDisposeCallback(element, function () {
                            body.removeEventListener("scroll", updateCachedSizes);
                            window.removeEventListener("resize", onResizeBoundFunction);
                        });
                    };
                    TreeGridViewModel.prototype.onResultChanged = function (resultId) {
                        var _this = this;
                        this.loadDataOperation(function () { return _this._dao.getRoots(resultId, _this._header.sortInfo()); });
                    };
                    TreeGridViewModel.prototype.onSortChanged = function (sortInfo) {
                        var _this = this;
                        this.loadDataOperation(function () { return _this._dao.sort(_this._roots(), sortInfo); });
                    };
                    TreeGridViewModel.prototype.search = function (query, isCaseSensitive, isRegex) {
                        var _this = this;
                        if (this._dataLoadPromise) {
                            this._logger.error("Trying to search while loading data, this should not happen");
                            return Microsoft.Plugin.Promise.as(false);
                        }
                        if (!query) {
                            return Microsoft.Plugin.Promise.as(false);
                        }
                        var currentNode = null;
                        var currentChildren = this._roots();
                        var expandSearch = function (result) {
                            var nodeToExpand = result.shift();
                            for (var nodeIndex = 0; nodeIndex < currentChildren.length; ++nodeIndex) {
                                currentNode = currentChildren[nodeIndex];
                                if (currentNode.id === nodeToExpand.nodeId) {
                                    currentChildren = currentNode.children();
                                    break;
                                }
                            }
                            if (result.length > 0) {
                                if (!currentNode.expanded()) {
                                    return _this._dao.expand(currentNode, _this._header.sortInfo()).then(function () { return expandSearch(result); });
                                }
                                else {
                                    return expandSearch(result);
                                }
                            }
                            else {
                                ko.tasks.schedule(function () {
                                    var indexToSelect = _this._treeAsArrayProjection().indexOf(currentNode);
                                    _this._selectedRows([indexToSelect]);
                                });
                                return Microsoft.Plugin.Promise.as(true);
                            }
                        };
                        var processSearchResult = function (result) {
                            if (result.length > 0) {
                                return expandSearch(result);
                            }
                            if (_this._selectedRows().length === 0) {
                                return _this._automation.getAlertPromise(DiagnosticsHub.AutomationConstants.SearchNoResultsAlertKey, Microsoft.Plugin.Resources.getString("Message_SearchNoMatches"))
                                    .then(function () { return false; });
                            }
                            return _this._automation.getConfirmationPromise(DiagnosticsHub.AutomationConstants.SearchNoResultsConfirmationKey, Microsoft.Plugin.Resources.getString("Message_SearchStartFromTop"))
                                .then(function (startFromTop) {
                                if (!startFromTop) {
                                    return Microsoft.Plugin.Promise.as(false);
                                }
                                _this._selectedRows([]);
                                return _this._dao.search(query, isCaseSensitive, isRegex, null, _this._header.sortInfo())
                                    .then(processSearchResult);
                            });
                        };
                        this._dataLoadPromise = this._dao.search(query, isCaseSensitive, isRegex, this.focusedRow(), this._header.sortInfo())
                            .then(processSearchResult);
                        this._dataLoadPromise.done(function () { return _this._dataLoadPromise = null; }, function (error) {
                            _this._dataLoadPromise = null;
                            _this._logger.error("Tree grid search failed");
                            if (parseInt(error.name, 16) === DiagnosticsHub.ErrorCodes.VSHUB_E_INVALID_REGEX) {
                                window.alert(Microsoft.Plugin.Resources.getString("ErrMsg_InvalidRegularExpression"));
                            }
                        });
                        return this._dataLoadPromise;
                    };
                    TreeGridViewModel.prototype.onClick = function (viewModel, event) {
                        var _this = this;
                        if (event.which !== DiagnosticsHub.Common.MouseCodes.Left) {
                            return;
                        }
                        var context = ko.contextFor(event.target);
                        if (!context || context.$data === this) {
                            return;
                        }
                        var row = context.$data;
                        var rowIndex = this._treeAsArrayProjection().indexOf(row);
                        if (event.target.classList && event.target.classList.contains("treeGridRow-expander")) {
                            this._selectedRows([rowIndex]);
                            ko.tasks.runEarly();
                            this._dao.expand(row, this._header.sortInfo());
                        }
                        else if (event.ctrlKey) {
                            var selectedIndex = this._selectedRows().indexOf(rowIndex);
                            if (selectedIndex === -1) {
                                this._selectedRows.push(rowIndex);
                            }
                            else {
                                this._selectedRows.splice(selectedIndex, 1);
                            }
                        }
                        else if (event.shiftKey) {
                            var start = Math.max(Math.min(this.focusedRowIndex(), rowIndex), 0);
                            var end = Math.max(this.focusedRowIndex(), rowIndex);
                            var initialSelection = this._selectedRows();
                            var selectionToAdd = [];
                            for (var indexToSelect = start; indexToSelect <= end; ++indexToSelect) {
                                if (initialSelection.indexOf(indexToSelect) === -1) {
                                    selectionToAdd.push(indexToSelect);
                                }
                            }
                            if (this.focusedRowIndex() > rowIndex) {
                                selectionToAdd.reverse();
                            }
                            selectionToAdd.forEach(function (selection) { return _this._selectedRows.push(selection); });
                        }
                        else {
                            this._selectedRows([rowIndex]);
                        }
                    };
                    TreeGridViewModel.prototype.onDblClick = function (viewModel, event) {
                        if (event.which !== DiagnosticsHub.Common.MouseCodes.Left) {
                            return;
                        }
                        var context = ko.contextFor(event.target);
                        if (event.target.classList && event.target.classList.contains("treeGridRow-expander")) {
                            var rowIndex = this._treeAsArrayProjection().indexOf(context.$data);
                            this._selectedRows([rowIndex]);
                            ko.tasks.runEarly();
                            this._dao.expand(context.$data, this._header.sortInfo());
                        }
                        else if (context && context.$data !== this && this._selectedRows().length > 0) {
                            if (this.focusedRow() === context.$data) {
                                this.focusedRow().invoke();
                            }
                            else {
                                this.onClick(viewModel, event);
                            }
                        }
                    };
                    TreeGridViewModel.prototype.onKeyDown = function (viewModel, event) {
                        var focusedRow = this.focusedRow();
                        if (!focusedRow) {
                            return true;
                        }
                        if (DiagnosticsHub.Common.KeyCodes.Enter === event.keyCode) {
                            focusedRow.invoke();
                            return false;
                        }
                        if (DiagnosticsHub.Common.KeyCodes.Space !== event.keyCode && DiagnosticsHub.Common.KeyCodes.ArrowRight !== event.keyCode && DiagnosticsHub.Common.KeyCodes.ArrowLeft !== event.keyCode) {
                            return true;
                        }
                        this._selectedRows([this.focusedRowIndex()]);
                        ko.tasks.runEarly();
                        if (DiagnosticsHub.Common.KeyCodes.Space === event.keyCode) {
                            this._dao.expand(focusedRow, this._header.sortInfo());
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.ArrowLeft === event.keyCode) {
                            focusedRow.expanded(false);
                        }
                        else if (DiagnosticsHub.Common.KeyCodes.ArrowRight === event.keyCode && !focusedRow.expanded()) {
                            this._dao.expand(focusedRow, this._header.sortInfo());
                        }
                        return false;
                    };
                    TreeGridViewModel.prototype.loadDataOperation = function (operation) {
                        var _this = this;
                        if (this._dataLoadPromise) {
                            this._dataLoadPromise.cancel();
                        }
                        this._selectedRows([]);
                        ko.tasks.runEarly();
                        this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadStart);
                        this._dataLoadPromise = operation().then(function (roots) { return _this._roots(roots); });
                        this._dataLoadPromise.done(function () {
                            _this._dataLoadPromise = null;
                            _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCompleted);
                        }, function (error) {
                            if (error.name === CpuUsage.Constants.errorNameCanceled) {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCanceled);
                            }
                            else {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadFailed);
                            }
                            _this._dataLoadPromise = null;
                        });
                    };
                    TreeGridViewModel.prototype.computeTreeAsArrayProjection = function () {
                        var projection = [];
                        var getProjection = function (element) {
                            projection.push(element);
                            if (element.expanded()) {
                                element.children().forEach(getProjection);
                            }
                        };
                        this._roots().forEach(getProjection);
                        return projection;
                    };
                    TreeGridViewModel.prototype.computedFocusedRowIndex = function () {
                        var selectedRows = this._selectedRows();
                        return selectedRows.length > 0 ? selectedRows[selectedRows.length - 1] : -1;
                    };
                    TreeGridViewModel.prototype.computeFocusedRow = function () {
                        var focusedIndex = this.computedFocusedRowIndex();
                        return focusedIndex !== -1 ? this._treeAsArrayProjection()[focusedIndex] : null;
                    };
                    TreeGridViewModel.prototype.onSelectionChanged = function (changes) {
                        var _this = this;
                        changes.forEach(function (change) {
                            if (typeof change.moved !== "undefined") {
                                return;
                            }
                            if (change.status === "added") {
                                _this._treeAsArrayProjection()[change.value].selected(true);
                            }
                            else if (change.status === "deleted") {
                                _this._treeAsArrayProjection()[change.value].selected(false);
                            }
                        });
                    };
                    return TreeGridViewModel;
                }());
                CpuUsage.TreeGridViewModel = TreeGridViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var SortFunctions = (function () {
                    function SortFunctions() {
                    }
                    SortFunctions.getSortProperty = function (sortColumn) {
                        switch (sortColumn) {
                            case CpuUsage.SortColumn.Id:
                                return "id";
                            case CpuUsage.SortColumn.FunctionName:
                                return "name";
                            case CpuUsage.SortColumn.InclusiveSamples:
                                return "inclusiveSamples";
                            case CpuUsage.SortColumn.ExclusiveSamples:
                                return "exclusiveSamples";
                            case CpuUsage.SortColumn.InclusivePercent:
                                return "inclusivePercent";
                            case CpuUsage.SortColumn.ExclusivePercent:
                                return "exclusivePercent";
                            case CpuUsage.SortColumn.ModuleName:
                                return "moduleName";
                            default:
                                DiagnosticsHub.Debug.Assert.fail("Unknown sort column: " + sortColumn);
                                throw new Error("Unknown sort column: " + sortColumn);
                        }
                    };
                    SortFunctions.getSortFunction = function (sortInfo) {
                        var propertyToSortBy = SortFunctions.getSortProperty(sortInfo.column);
                        var sortDirection = sortInfo.direction === CpuUsage.SortDirection.Asc ? 1 : -1;
                        return function (left, right) {
                            var leftValue = ko.utils.unwrapObservable(left[propertyToSortBy]);
                            var rightValue = ko.utils.unwrapObservable(right[propertyToSortBy]);
                            if (typeof leftValue === "string" && typeof rightValue === "string") {
                                leftValue = leftValue.toUpperCase();
                                rightValue = rightValue.toUpperCase();
                            }
                            if (leftValue === rightValue) {
                                return 0;
                            }
                            return leftValue < rightValue ? -sortDirection : sortDirection;
                        };
                    };
                    return SortFunctions;
                }());
                CpuUsage.SortFunctions = SortFunctions;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var FlatFunctionsDAO = (function () {
                    function FlatFunctionsDAO(dataWarehouse) {
                        this._functionLimit = 250;
                        this._dataWarehouse = dataWarehouse;
                    }
                    FlatFunctionsDAO.prototype.getRoots = function (resultId, sortInfo) {
                        this._currentResult = this._dataWarehouse.getResultById(resultId);
                        return this._currentResult.getResult({
                            view: "flat-functions",
                            type: CpuUsage.ResultTaskType.GetData,
                            sort: sortInfo,
                            functionLimit: this._functionLimit
                        })
                            .then(function (result) {
                            return result.map(function (processRecord) { return new CpuUsage.ProcessRowViewModel(processRecord); });
                        });
                    };
                    FlatFunctionsDAO.prototype.sort = function (roots, sortInfo) {
                        if (!this._currentResult) {
                            return Microsoft.Plugin.Promise.as(roots);
                        }
                        return this._currentResult.getResult({
                            view: "flat-functions",
                            type: CpuUsage.ResultTaskType.GetData,
                            sort: sortInfo,
                            functionLimit: this._functionLimit
                        })
                            .then(function (result) {
                            return result.map(function (processRecord) { return new CpuUsage.ProcessRowViewModel(processRecord); });
                        });
                    };
                    FlatFunctionsDAO.prototype.search = function (query, isCaseSensitive, isRegex, startingRow, sortInfo) {
                        var idPath = [];
                        if (startingRow) {
                            var isFunctionRow = !startingRow.children || startingRow.children().length === 0;
                            if (isFunctionRow) {
                                idPath = startingRow.getIdPath();
                            }
                            else {
                                idPath = startingRow.getIdPath();
                            }
                        }
                        return this._currentResult.getResult({
                            view: "flat-functions",
                            type: CpuUsage.ResultTaskType.Search,
                            selectedPath: idPath,
                            str: query,
                            caseSensitive: isCaseSensitive,
                            isRegex: isRegex,
                            functionLimit: this._functionLimit
                        });
                    };
                    FlatFunctionsDAO.prototype.expand = function (row, sortInfo) {
                        if (row.expanded()) {
                            row.expanded(false);
                        }
                        else if (row.children().length > 0) {
                            row.expanded(true);
                        }
                        return Microsoft.Plugin.Promise.as(void 0);
                    };
                    return FlatFunctionsDAO;
                }());
                CpuUsage.FlatFunctionsDAO = FlatFunctionsDAO;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var FlatFunctionsViewModel = (function () {
                    function FlatFunctionsViewModel(dataWarehouse, templateName) {
                        var _this = this;
                        this._resultId = ko.observable(null);
                        this._toolContext = ko.observable(null);
                        this._treeGridViewModel = new CpuUsage.TreeGridViewModel(new CpuUsage.FlatFunctionsDAO(dataWarehouse), new CpuUsage.TreeGridHeaderViewModel(templateName, new CpuUsage.CpuToolColumnProvider(templateName)));
                        this._resultId.subscribe(function (resultId) { return _this._treeGridViewModel.onResultChanged(resultId); });
                    }
                    Object.defineProperty(FlatFunctionsViewModel.prototype, "resultId", {
                        get: function () {
                            return this._resultId;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FlatFunctionsViewModel.prototype, "toolContext", {
                        get: function () {
                            return this._toolContext;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FlatFunctionsViewModel.prototype, "dataLoadStatus", {
                        get: function () {
                            return this._treeGridViewModel.dataLoadStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(FlatFunctionsViewModel.prototype, "gridViewModel", {
                        get: function () {
                            return this._treeGridViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    FlatFunctionsViewModel.prototype.onKeyDown = function (viewModel, event) {
                        if (!(event.ctrlKey && event.keyCode === DiagnosticsHub.Common.KeyCodes.C)) {
                            return true;
                        }
                        var selectedIndexes = viewModel.gridViewModel.selectedRows();
                        var treeAsArray = viewModel.gridViewModel.treeAsArray();
                        var selectedRows = selectedIndexes.sort(CpuUsage.CpuSamplingUtilities.numberComparator).map(function (index) { return treeAsArray[index]; });
                        var formattedSelection = CpuUsage.FlatFunctionsClipboardFormatter.formatSelection(selectedRows);
                        window.clipboardData.setData("Text", formattedSelection);
                        return false;
                    };
                    return FlatFunctionsViewModel;
                }());
                CpuUsage.FlatFunctionsViewModel = FlatFunctionsViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallTreeViewModel = (function () {
                    function CallTreeViewModel(dataWarehouse, resultId, toolContext) {
                        var _this = this;
                        this._resultId = ko.observable(resultId);
                        this._toolContext = ko.observable(toolContext);
                        this._treeGridViewModel = new CpuUsage.TreeGridViewModel(new CpuUsage.CallTreeDAO(dataWarehouse), new CpuUsage.TreeGridHeaderViewModel("CallTreeHeaderView", new CpuUsage.CpuToolColumnProvider("CallTreeHeaderView")));
                        this._resultId.subscribe(function (resultId) { return _this._treeGridViewModel.onResultChanged(resultId); });
                        this._treeGridViewModel.onResultChanged(resultId);
                    }
                    Object.defineProperty(CallTreeViewModel.prototype, "resultId", {
                        get: function () {
                            return this._resultId;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeViewModel.prototype, "toolContext", {
                        get: function () {
                            return this._toolContext;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeViewModel.prototype, "dataLoadStatus", {
                        get: function () {
                            return this._treeGridViewModel.dataLoadStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallTreeViewModel.prototype, "gridViewModel", {
                        get: function () {
                            return this._treeGridViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    CallTreeViewModel.prototype.onKeyDown = function (viewModel, event) {
                        if (!(event.ctrlKey && event.keyCode === DiagnosticsHub.Common.KeyCodes.C)) {
                            return true;
                        }
                        var selectedIndexes = viewModel.gridViewModel.selectedRows().sort(CpuUsage.CpuSamplingUtilities.numberComparator);
                        var treeAsArray = viewModel.gridViewModel.treeAsArray();
                        var formattedSelection = CpuUsage.CallTreeClipboardFormatter.formatSelection(selectedIndexes, treeAsArray);
                        window.clipboardData.setData("Text", formattedSelection);
                        return false;
                    };
                    return CallTreeViewModel;
                }());
                CpuUsage.CallTreeViewModel = CallTreeViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var AnalysisDetailsViewModel = (function () {
                    function AnalysisDetailsViewModel() {
                        var _this = this;
                        this._logger = DiagnosticsHub.getLogger();
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._telemetryCpuUsage = new CpuUsage.CpuToolTelemetryPortMarshaler();
                        this._automation = DiagnosticsHub.getAutomationManager(this._logger);
                        this._progressViewModel = new DiagnosticsHub.ProgressViewModel(Microsoft.Plugin.Resources.getString("PreparingCpuUsageDataProgressTaskName"), 100);
                        this._isCreateDetailedReportDisabled = ko.observable(false);
                        this._resultStatus = ko.observable(null);
                        this._isVisible = true;
                        this._viewId = CpuUsage.Constants.functionsAnalysisDetailsViewId;
                        this._resultStatus.equalityComparer = CpuUsage.CpuSamplingUtilities.areResultStatusesEqual;
                        var dataWarehouse;
                        Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse()
                            .then(function (dw) {
                            dataWarehouse = dw;
                            return _this._cpuToolMarshaler.getCurrentResultStatus();
                        })
                            .then(function (resultStatus) {
                            _this._resultStatus(resultStatus);
                            return dataWarehouse.getContextService();
                        })
                            .then(function (contextService) { return contextService.getGlobalContext(); })
                            .then(function (globalContext) { return globalContext.getTimeDomain(); })
                            .then(function (timeDomain) {
                            _this._flatFunctionsViewModel = new CpuUsage.FlatFunctionsViewModel(dataWarehouse, "AnalysisFunctionsHeaderView");
                            _this._threadFilterViewModel = new CpuUsage.ThreadFilterViewModel(dataWarehouse);
                            _this._threadFilterViewModel.isDisabled(false);
                            _this._searchViewModel = new CpuUsage.SearchControlViewModel(_this._flatFunctionsViewModel.gridViewModel, true);
                            _this._currentOverlay = ko.pureComputed(function () { return _this.computeOverlay(); });
                            _this._isOverlayActive = ko.pureComputed(function () { return _this._currentOverlay() !== null; });
                            _this._isOverlayActive.subscribe(function (overlayActive) {
                                _this._searchViewModel.isDisabled(overlayActive);
                                _this._threadFilterViewModel.isDisabled(overlayActive);
                                _this._isCreateDetailedReportDisabled(overlayActive);
                            });
                            _this._resultStatus.subscribe(function (resultStatus) { return _this.onResultStatusChanged(resultStatus); });
                            _this._progressViewModel.cancellationRequestedEvent.addEventListener(function () {
                                _this._cpuToolMarshaler.tryCancelResult(_this._resultStatus().taskId);
                            });
                            _this._threadFilterViewModel.timeDomain(timeDomain);
                            var viewEventManager = DiagnosticsHub.getViewEventManager();
                            viewEventManager.selectionChanged.addEventListener(_this.onTimeRangeChangedEvent.bind(_this));
                            viewEventManager.detailsViewSelectionChanged.addEventListener(_this.onDetailsViewSelectionChangedEvent.bind(_this));
                            _this._cpuToolMarshaler.resultStatusUpdatedEvent.addEventListener(function (eventArgs) { return _this._resultStatus(eventArgs.currentResultStatus); });
                            ko.applyBindings(_this);
                            viewEventManager.detailsViewReady.raiseEvent({ Id: _this._viewId });
                        });
                    }
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "mainViewModel", {
                        get: function () {
                            return this._flatFunctionsViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "threadFilterViewModel", {
                        get: function () {
                            return this._threadFilterViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "searchViewModel", {
                        get: function () {
                            return this._searchViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "currentOverlay", {
                        get: function () {
                            return this._currentOverlay;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "isCreateDetailedReportDisabled", {
                        get: function () {
                            return this._isCreateDetailedReportDisabled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(AnalysisDetailsViewModel.prototype, "isUnsupported", {
                        get: function () {
                            return false;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    AnalysisDetailsViewModel.prototype.createDetailedReport = function () {
                        var _this = this;
                        this._telemetryCpuUsage.createDetailedReport();
                        this._isCreateDetailedReportDisabled(true);
                        DiagnosticsHub.getCurrentDocument().openInAlternateFormat(1)
                            .done(function () { return _this._isCreateDetailedReportDisabled(false); }, function (error) {
                            _this._isCreateDetailedReportDisabled(false);
                            _this._logger.debug("Create detailed report failure: " + JSON.stringify(error));
                            _this._automation.getAlertPromise("Microsoft.VisualStudio.DiagnosticsHub.CpuUsageTreeGrid.CreateDetailedReport", Microsoft.Plugin.Resources.getString("ErrMsg_FailedToCreateDetailedReport"));
                        });
                    };
                    AnalysisDetailsViewModel.prototype.onTimeRangeChangedEvent = function (eventArgs) {
                        if (eventArgs.isIntermittent) {
                            return;
                        }
                        this._threadFilterViewModel.timeDomain(eventArgs.position);
                    };
                    AnalysisDetailsViewModel.prototype.onDetailsViewSelectionChangedEvent = function (eventArgs) {
                        this._isVisible = eventArgs.Id.toUpperCase() === this._viewId.toUpperCase();
                        if (!this._isVisible) {
                            return;
                        }
                        if (this._resultStatus().preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                            this._flatFunctionsViewModel.resultId(this._resultStatus().resultId);
                        }
                    };
                    AnalysisDetailsViewModel.prototype.onResultStatusChanged = function (resultStatus) {
                        if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.NotStarted ||
                            resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.InProgress) {
                            this._progressViewModel.currentValue(resultStatus.completionPercentage);
                        }
                        else if (this._isVisible && resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                            this._flatFunctionsViewModel.resultId(resultStatus.resultId);
                        }
                    };
                    AnalysisDetailsViewModel.prototype.computeOverlay = function () {
                        var resultStatus = this._resultStatus();
                        if (this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadStart) {
                            return {
                                name: "ProgressView",
                                data: this._threadFilterViewModel.progress
                            };
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.InProgress) {
                            return {
                                name: "ProgressView",
                                data: this._progressViewModel
                            };
                        }
                        else if (this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadCanceled ||
                            resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Canceled) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuAnalysisDetailsViewOperationIncomplete")
                            };
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Failed ||
                            this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadFailed ||
                            this._flatFunctionsViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadFailed) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuDetailsViewUnableShowData")
                            };
                        }
                        return null;
                    };
                    return AnalysisDetailsViewModel;
                }());
                CpuUsage.AnalysisDetailsViewModel = AnalysisDetailsViewModel;
                var _analysisDetailsViewModel = null;
                function getAnalysisDetailsViewModel() {
                    if (!_analysisDetailsViewModel) {
                        _analysisDetailsViewModel = new Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.AnalysisDetailsViewModel();
                    }
                    return _analysisDetailsViewModel;
                }
                CpuUsage.getAnalysisDetailsViewModel = getAnalysisDetailsViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
ko.bindingHandlers["localizedTooltip"] = {
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var keyWithArgs = valueAccessor();
        if (!Array.isArray(keyWithArgs)) {
            keyWithArgs = [keyWithArgs];
        }
        var unwrappedArgs = keyWithArgs.map(function (value) { return ko.unwrap(value); });
        element.setAttribute("data-plugin-vs-tooltip", JSON.stringify({
            content: Microsoft.Plugin.Resources.getString.apply(null, unwrappedArgs),
            delay: Microsoft.VisualStudio.DiagnosticsHub.Constants.TooltipTimeoutMs
        }));
    }
};
ko.bindingHandlers["onEnter"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        element.addEventListener("keydown", function (e) {
            if (Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.Enter !== e.keyCode) {
                return;
            }
            var eventHandler = valueAccessor();
            var allowPropagation = eventHandler.apply(viewModel, [viewModel, e]);
            if (!allowPropagation) {
                e.preventDefault();
            }
        });
    }
};
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var EnableSamplingButtonViewModel = (function () {
                    function EnableSamplingButtonViewModel(clickHandler) {
                        var _this = this;
                        this._toggled = ko.observable(false);
                        this._enabled = ko.observable(true);
                        this._clickHandler = clickHandler;
                        var template = document.createElement("div");
                        template.innerHTML = document.getElementById("EnableSamplingButtonView").innerHTML;
                        this._tooltip = ko.pureComputed(function () {
                            return JSON.stringify({
                                content: _this._toggled() ?
                                    Microsoft.Plugin.Resources.getString("ButtonTooltip_CPUProfilingToggled") :
                                    Microsoft.Plugin.Resources.getString("ButtonTooltip_CPUProfilingNotToggled")
                            });
                        });
                    }
                    Object.defineProperty(EnableSamplingButtonViewModel.prototype, "toggled", {
                        get: function () {
                            return this._toggled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnableSamplingButtonViewModel.prototype, "enabled", {
                        get: function () {
                            return this._enabled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnableSamplingButtonViewModel.prototype, "ariaLabel", {
                        get: function () {
                            if (this.toggled()) {
                                return Microsoft.Plugin.Resources.getString("ButtonTooltip_CPUProfilingToggled");
                            }
                            else {
                                return Microsoft.Plugin.Resources.getString("ButtonTooltip_CPUProfilingNotToggled");
                            }
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(EnableSamplingButtonViewModel.prototype, "tooltip", {
                        get: function () {
                            return this._tooltip;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    EnableSamplingButtonViewModel.prototype.onClick = function (viewModel, event) {
                        this._clickHandler(event);
                        return false;
                    };
                    return EnableSamplingButtonViewModel;
                }());
                CpuUsage.EnableSamplingButtonViewModel = EnableSamplingButtonViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            "use strict";
            var ProgressViewModel = (function () {
                function ProgressViewModel(stageName, maxValue) {
                    this._cancellationRequestedEvent = new DiagnosticsHub.AggregatedEvent();
                    this._currentValue = ko.observable(0);
                    this._stageName = stageName;
                    this._maxValue = maxValue;
                }
                Object.defineProperty(ProgressViewModel.prototype, "stageName", {
                    get: function () {
                        return this._stageName;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ProgressViewModel.prototype, "maxValue", {
                    get: function () {
                        return this._maxValue;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ProgressViewModel.prototype, "currentValue", {
                    get: function () {
                        return this._currentValue;
                    },
                    enumerable: true,
                    configurable: true
                });
                Object.defineProperty(ProgressViewModel.prototype, "cancellationRequestedEvent", {
                    get: function () {
                        return this._cancellationRequestedEvent;
                    },
                    enumerable: true,
                    configurable: true
                });
                ProgressViewModel.prototype.cancel = function () {
                    this._cancellationRequestedEvent.invokeEvent(null);
                };
                return ProgressViewModel;
            }());
            DiagnosticsHub.ProgressViewModel = ProgressViewModel;
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var BreakAllViewModel = (function () {
                    function BreakAllViewModel() {
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._telemetry = new CpuUsage.CpuToolTelemetryPortMarshaler();
                        this._inBreak = false;
                        this._breakPending = ko.observable(false);
                    }
                    Object.defineProperty(BreakAllViewModel.prototype, "breakPending", {
                        get: function () {
                            return this._breakPending;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(BreakAllViewModel.prototype, "ariaLabel", {
                        get: function () {
                            return Microsoft.Plugin.Resources.getString("CpuDetailsViewSelectionDebugRun_Prehyperlink") +
                                Microsoft.Plugin.Resources.getString("CpuDetailsViewSelectionDebugRun_BreakAll") +
                                Microsoft.Plugin.Resources.getString("CpuDetailsViewSelectionDebugRun_Posthyperlink");
                        },
                        enumerable: true,
                        configurable: true
                    });
                    BreakAllViewModel.prototype.onBreakEvent = function (inBreak) {
                        this._inBreak = inBreak;
                        this.breakPending(false);
                    };
                    BreakAllViewModel.prototype.breakAll = function () {
                        var _this = this;
                        this.breakPending(true);
                        this._cpuToolMarshaler.breakAll()
                            .done(function (success) { return _this._telemetry.breakAllInvoked(success); });
                    };
                    return BreakAllViewModel;
                }());
                CpuUsage.BreakAllViewModel = BreakAllViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var PerformanceDebuggerDetailsViewModel = (function () {
                    function PerformanceDebuggerDetailsViewModel(marshaler, transportServiceController) {
                        var _this = this;
                        this._telemetryCpuUsage = new CpuUsage.CpuToolTelemetryPortMarshaler();
                        this._progressViewModel = new DiagnosticsHub.ProgressViewModel(Microsoft.Plugin.Resources.getString("PreparingCpuUsageDataProgressTaskName"), 100);
                        this._breakAllViewModel = new CpuUsage.BreakAllViewModel();
                        this._agentErrorMessage = ko.observable("");
                        this._isUnsupported = ko.observable(false);
                        this._neverBeenEnabled = ko.observable(true);
                        this._sessionState = ko.observable(0);
                        this._enablePending = ko.observable(false);
                        this._cpuCollectionEnabled = ko.observable(false);
                        this._isInBreak = ko.observable(false);
                        this._currentOverlay = ko.pureComputed(function () { return _this.computeOverlay(); });
                        this._selectedTimeRange = ko.observable(null);
                        this._timeDomain = ko.pureComputed(function () { return _this.computeTimeDomain(); });
                        this._resultStatus = ko.observable(null);
                        this._isVisible = true;
                        this._viewId = CpuUsage.Constants.functionsPerformanceDebuggerDetailsViewId;
                        this._cpuToolMarshaler = marshaler;
                        this._collectorTransportServiceController = transportServiceController;
                        this._cpuToolMarshaler.isToolSupported()
                            .then(function (toolSupported) {
                            if (!toolSupported) {
                                _this._isUnsupported(true);
                                ko.applyBindings(_this);
                                DiagnosticsHub.getViewEventManager().detailsViewReady.raiseEvent({ Id: _this._viewId });
                                return;
                            }
                            return _this.initialize();
                        });
                    }
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "mainViewModel", {
                        get: function () {
                            return this._flatFunctionsViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "threadFilterViewModel", {
                        get: function () {
                            return this._threadFilterViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "searchViewModel", {
                        get: function () {
                            return this._searchViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "enableSamplingButtonViewModel", {
                        get: function () {
                            return this._enableSamplingButtonViewModel;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "cpuCollectionEnabled", {
                        get: function () {
                            return this._cpuCollectionEnabled;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "currentOverlay", {
                        get: function () {
                            return this._currentOverlay;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(PerformanceDebuggerDetailsViewModel.prototype, "isUnsupported", {
                        get: function () {
                            return this._isUnsupported;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    PerformanceDebuggerDetailsViewModel.prototype.setCollectionEnabled = function (enabled) {
                        this._enablePending(true);
                        return this._cpuToolMarshaler.setCollectionEnabled(enabled);
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.initialize = function () {
                        var _this = this;
                        this._selectedTimeRange.equalityComparer = CpuUsage.CpuSamplingUtilities.areTimespansEqual;
                        this._resultStatus.equalityComparer = CpuUsage.CpuSamplingUtilities.areResultStatusesEqual;
                        this._isEnabledForSelection = CpuUsage.CpuSamplingUtilities.asyncComputed(function () {
                            if (!_this._selectedTimeRange()) {
                                return Microsoft.Plugin.Promise.as(false);
                            }
                            return _this._cpuToolMarshaler.isToolEnabledForTimespan(_this._selectedTimeRange());
                        }, this._cpuToolMarshaler.enabledTimeRangesChangedEvent);
                        return this._cpuToolMarshaler.isToolEnabled()
                            .then(function (viewEnabledAtStart) {
                            _this._neverBeenEnabled(!viewEnabledAtStart);
                            _this._cpuCollectionEnabled(viewEnabledAtStart);
                            _this._telemetryCpuUsage.enabledAtStart(viewEnabledAtStart);
                            _this._cpuAgentClassId = viewEnabledAtStart ? CpuUsage.Constants.agentOnByDefaultClassId : CpuUsage.Constants.agentOffByDefaultClassId;
                            var performanceDebuggerStateService = DiagnosticsHub.getPerformanceDebuggerStateService();
                            return performanceDebuggerStateService.isDocumentActiveSession();
                        }).then(function (isActiveSession) {
                            if (!isActiveSession) {
                                return;
                            }
                            var session = DiagnosticsHub.getCurrentSession();
                            session.addStateChangedEventListener(function (args) { return _this._sessionState(args.currentState); });
                            return session.getState()
                                .then(function (sessionState) { return _this._sessionState(sessionState); });
                        })
                            .then(function () { return Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse(); })
                            .then(function (dataWarehouse) { return _this._dataWarehouse = dataWarehouse; })
                            .then(function () { return _this._cpuToolMarshaler.getCurrentResultStatus(); })
                            .then(function (resultStatus) {
                            _this._resultStatus(resultStatus);
                            _this._flatFunctionsViewModel = new CpuUsage.FlatFunctionsViewModel(_this._dataWarehouse, "PerfDebuggerFunctionsHeaderView");
                            _this._threadFilterViewModel = new CpuUsage.ThreadFilterViewModel(_this._dataWarehouse);
                            _this._searchViewModel = new CpuUsage.SearchControlViewModel(_this._flatFunctionsViewModel.gridViewModel, false);
                            _this._enableSamplingButtonViewModel = new CpuUsage.EnableSamplingButtonViewModel(function () { return _this.setCollectionEnabled(!_this._cpuCollectionEnabled()); });
                            _this._enableSamplingButtonViewModel.toggled(_this._cpuCollectionEnabled());
                            _this._isOverlayActive = ko.pureComputed(function () { return _this._currentOverlay() !== null; });
                            _this._isOverlayActive.subscribe(function (isOverlayActive) {
                                _this._searchViewModel.isDisabled(isOverlayActive);
                                _this._threadFilterViewModel.isDisabled(isOverlayActive);
                            });
                            _this._resultStatus.subscribe(function (resultStatus) { return _this.onResultStatusChanged(resultStatus); });
                            _this._progressViewModel.cancellationRequestedEvent.addEventListener(function () {
                                _this._cpuToolMarshaler.tryCancelResult(_this._resultStatus().taskId);
                            });
                            _this._cpuCollectionEnabled.subscribe(function (enabled) {
                                _this._telemetryCpuUsage.enabledToggle(enabled);
                                _this._enableSamplingButtonViewModel.toggled(enabled);
                            });
                            _this._isInBreak.subscribe(function (inBreak) {
                                _this._breakAllViewModel.onBreakEvent(inBreak);
                                if (!inBreak) {
                                    _this._threadFilterViewModel.dataLoadPromise.cancel();
                                    _this._cpuToolMarshaler.tryCancelResult(_this._resultStatus().taskId);
                                }
                            });
                            _this._timeDomain.subscribe(function (timespan) {
                                if (!timespan) {
                                    return;
                                }
                                _this._threadFilterViewModel.timeDomain(timespan);
                            });
                            _this._selectedTimeRange.subscribe(function () {
                                _this.threadFilterViewModel.dataLoadPromise.cancel();
                                _this._cpuToolMarshaler.tryCancelResult(_this._resultStatus().taskId);
                            });
                            _this._enablePending.subscribe(function (pending) {
                                _this._agentErrorMessage("");
                                _this._enableSamplingButtonViewModel.enabled(!pending);
                            });
                            _this._cpuToolMarshaler.collectionEnabledEvent.addEventListener(_this.onCollectionEnabled.bind(_this));
                            _this._cpuToolMarshaler.collectionDisabledEvent.addEventListener(_this.onCollectionDisabled.bind(_this));
                            var performanceDebuggerEventManager = Microsoft.VisualStudio.DiagnosticsHub.getPerformanceDebuggerEventManager();
                            performanceDebuggerEventManager.debugModeBreakEvent.addEventListener(function () { return _this._isInBreak(true); });
                            performanceDebuggerEventManager.debugModeRunEvent.addEventListener(function () { return _this._isInBreak(false); });
                            performanceDebuggerEventManager.isDebuggerInBreakMode().then(function (isInBreak) { return _this._isInBreak(isInBreak); });
                            var viewEventManager = DiagnosticsHub.getViewEventManager();
                            viewEventManager.selectionChanged.addEventListener(_this.onTimeRangeChangedEvent.bind(_this));
                            viewEventManager.detailsViewSelectionChanged.addEventListener(_this.onDetailsViewSelectionChangedEvent.bind(_this));
                            viewEventManager.selectionChanged.getTimeRange().then(function (timeRange) { return _this._selectedTimeRange(timeRange); });
                            _this._cpuToolMarshaler.resultStatusUpdatedEvent.addEventListener(function (eventArgs) { return _this._resultStatus(eventArgs.currentResultStatus); });
                            ko.applyBindings(_this);
                            viewEventManager.detailsViewReady.raiseEvent({ Id: _this._viewId });
                        });
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.onTimeRangeChangedEvent = function (eventArgs) {
                        if (eventArgs.isIntermittent) {
                            return;
                        }
                        this._selectedTimeRange(eventArgs.position);
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.onCollectionEnabled = function (agentResponse) {
                        this._enablePending(false);
                        if (agentResponse.hresult < 0) {
                            this._agentErrorMessage(Microsoft.Plugin.Resources.getString("CpuDetailsViewCannotEnableCpuProfiling", agentResponse.errorMessage));
                        }
                        else {
                            this._neverBeenEnabled(false);
                            this._cpuCollectionEnabled(true);
                        }
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.onCollectionDisabled = function (agentResponse) {
                        this._enablePending(false);
                        if (agentResponse.hresult < 0) {
                            this._agentErrorMessage(Microsoft.Plugin.Resources.getString("CpuDetailsViewCannotDisableCpuProfiling", agentResponse.errorMessage));
                        }
                        else {
                            this._cpuCollectionEnabled(false);
                        }
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.onResultStatusChanged = function (resultStatus) {
                        if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.NotStarted ||
                            resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.InProgress) {
                            this._progressViewModel.currentValue(resultStatus.completionPercentage);
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                            if (this._isVisible) {
                                this._flatFunctionsViewModel.resultId(resultStatus.resultId);
                            }
                        }
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.onDetailsViewSelectionChangedEvent = function (eventArgs) {
                        this._isVisible = eventArgs.Id.toUpperCase() === this._viewId.toUpperCase();
                        if (!this._isVisible) {
                            return;
                        }
                        if (this._resultStatus().preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                            this._flatFunctionsViewModel.resultId(this._resultStatus().resultId);
                        }
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.computeTimeDomain = function () {
                        if (this._isEnabledForSelection() && (this._isInBreak() || this._sessionState() !== 300)) {
                            return this._selectedTimeRange();
                        }
                        return null;
                    };
                    PerformanceDebuggerDetailsViewModel.prototype.computeOverlay = function () {
                        var _this = this;
                        if (this._isUnsupported()) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuDetailsViewNotSupported")
                            };
                        }
                        if (this._agentErrorMessage()) {
                            return {
                                name: "MessageView",
                                data: this._agentErrorMessage()
                            };
                        }
                        if (this._neverBeenEnabled()) {
                            return {
                                name: "NeverEnabledView",
                                data: {
                                    enableProfiling: function () { return _this.setCollectionEnabled(!_this._cpuCollectionEnabled()); },
                                    enablePending: this._enablePending
                                }
                            };
                        }
                        var resultStatus = this._resultStatus();
                        if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.NotStarted) {
                            if (resultStatus.notStartedReason === CpuUsage.ResultNotStartedReason.TargetRunningUnderDebugger) {
                                return {
                                    name: "BreakAllView",
                                    data: this._breakAllViewModel
                                };
                            }
                            else if (resultStatus.notStartedReason === CpuUsage.ResultNotStartedReason.NoValidTimeSelection) {
                                return {
                                    name: "MessageView",
                                    data: Microsoft.Plugin.Resources.getString("CpuDetailsViewNoSelectionDebugBreak")
                                };
                            }
                            else if (resultStatus.notStartedReason === CpuUsage.ResultNotStartedReason.ToolIsDisabled) {
                                return {
                                    name: "MessageView",
                                    data: Microsoft.Plugin.Resources.getString("CpuDetailsView_DisabledForSelection")
                                };
                            }
                            else if (resultStatus.notStartedReason === CpuUsage.ResultNotStartedReason.NoValidThreadSelection) {
                                if (this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadStart) {
                                    return {
                                        name: "ProgressView",
                                        data: this._threadFilterViewModel.progress
                                    };
                                }
                                else if (this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadCanceled) {
                                    return {
                                        name: "MessageView",
                                        data: Microsoft.Plugin.Resources.getString("CpuAnalysisDetailsViewOperationIncomplete")
                                    };
                                }
                            }
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.InProgress) {
                            return {
                                name: "ProgressView",
                                data: this._progressViewModel
                            };
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Canceled) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuAnalysisDetailsViewOperationIncomplete")
                            };
                        }
                        else if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Failed ||
                            this._threadFilterViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadFailed ||
                            this._flatFunctionsViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadFailed) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuDetailsViewUnableShowData")
                            };
                        }
                        return null;
                    };
                    return PerformanceDebuggerDetailsViewModel;
                }());
                CpuUsage.PerformanceDebuggerDetailsViewModel = PerformanceDebuggerDetailsViewModel;
                var _performanceDebuggerDetailsViewModel = null;
                function getPerformanceDebuggerDetailsViewModel() {
                    if (!_performanceDebuggerDetailsViewModel) {
                        var marshaler = new CpuUsage.CpuToolPortMarshaler();
                        var collectorTransportServiceController = DiagnosticsHub.Collectors.getCollectorTransportServiceController();
                        _performanceDebuggerDetailsViewModel = new Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.PerformanceDebuggerDetailsViewModel(marshaler, collectorTransportServiceController);
                    }
                    return _performanceDebuggerDetailsViewModel;
                }
                CpuUsage.getPerformanceDebuggerDetailsViewModel = getPerformanceDebuggerDetailsViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallerCalleeFunctionViewModel = (function () {
                    function CallerCalleeFunctionViewModel(dto) {
                        this._dto = dto;
                    }
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "name", {
                        get: function () {
                            if (this._dto.name) {
                                return this._dto.name;
                            }
                            switch (this._dto.aggType) {
                                case CpuUsage.AggregateType.SystemCode:
                                    return Microsoft.Plugin.Resources.getString("SystemCodeLabel");
                                case CpuUsage.AggregateType.JmcRejected:
                                    return Microsoft.Plugin.Resources.getString("ExternalCodeLabel");
                                case CpuUsage.AggregateType.ResumingAsyncMethod:
                                    return Microsoft.Plugin.Resources.getString("ResumingAsyncMethodLabel");
                            }
                            if (this._dto.groupedNodesBelowCallerCalleeLimit) {
                                return Microsoft.Plugin.Resources.getString("OtherLabel");
                            }
                            return "";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "inclusiveSamples", {
                        get: function () {
                            return this._dto.iSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "inclusivePercent", {
                        get: function () {
                            return this._dto.iPercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "exclusiveSamples", {
                        get: function () {
                            return this._dto.eSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "exclusivePercent", {
                        get: function () {
                            return this._dto.ePercent;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "totalSamples", {
                        get: function () {
                            return this._dto.totalSamples;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "address", {
                        get: function () {
                            return this._dto.address;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "fileName", {
                        get: function () {
                            return this._dto.fileName || "";
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "canNavigateTo", {
                        get: function () {
                            return !!this._dto.address;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "moduleName", {
                        get: function () {
                            if (this._dto.aggType && this._dto.aggType !== CpuUsage.AggregateType.Unknown) {
                                return Microsoft.Plugin.Resources.getString("MultipleModuleLabel");
                            }
                            if (this._dto.rtModule) {
                                return Microsoft.Plugin.Resources.getString("DotNetNativeBuildTimeAndRuntimeModuleFormat", this._dto.moduleName, this._dto.rtModule);
                            }
                            return this._dto.moduleName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeFunctionViewModel.prototype, "ariaLabel", {
                        get: function () {
                            return Microsoft.Plugin.Resources.getString("CallerCalleeFunctionAriaLabel", this.name, this.inclusiveSamples);
                        },
                        enumerable: true,
                        configurable: true
                    });
                    return CallerCalleeFunctionViewModel;
                }());
                CpuUsage.CallerCalleeFunctionViewModel = CallerCalleeFunctionViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallerCalleeViewModel = (function () {
                    function CallerCalleeViewModel(dataWarehouse, resultId, toolContext) {
                        var _this = this;
                        this._resultId = ko.observable(null);
                        this._callers = ko.observableArray([]);
                        this._currentFunction = ko.observable(null);
                        this._callees = ko.observableArray([]);
                        this._currentFunctionHasFocus = ko.observable(false);
                        this._currentFunctionName = ko.pureComputed(function () { return _this.computeCurrentFunctionName(); });
                        this._currentModuleName = ko.pureComputed(function () { return _this.computeCurrentModuleName(); });
                        this._atTopOfStack = ko.pureComputed(function () { return _this._callers().length === 0; });
                        this._atBottomOfStack = ko.pureComputed(function () { return _this._callees().length === 0; });
                        this._cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        this._resultContextId = "";
                        this._functionLimit = 5;
                        this._dataLoadStatus = ko.observable(CpuUsage.DataLoadEvent.DataLoadCompleted);
                        this._dataWarehouse = dataWarehouse;
                        this._resultId = ko.observable(resultId);
                        this._resultId.subscribe(function () {
                            var newToolContext = {};
                            if (CpuUsage.CpuSamplingUtilities.areToolContextsEqual(_this._toolContext(), newToolContext)) {
                                _this.loadData();
                            }
                            else {
                                _this._toolContext(newToolContext);
                            }
                        });
                        this._toolContext = ko.observable(toolContext);
                        this._toolContext.equalityComparer = CpuUsage.CpuSamplingUtilities.areToolContextsEqual;
                        this._toolContext.subscribe(function () { return _this.loadData(); });
                        this._currentFunction.subscribe(function () { return _this._currentFunctionHasFocus(true); });
                        this.loadData();
                    }
                    Object.defineProperty(CallerCalleeViewModel.prototype, "callers", {
                        get: function () {
                            return this._callers;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "currentFunction", {
                        get: function () {
                            return this._currentFunction;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "currentFunctionHasFocus", {
                        get: function () {
                            return this._currentFunctionHasFocus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "currentFunctionName", {
                        get: function () {
                            return this._currentFunctionName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "currentModuleName", {
                        get: function () {
                            return this._currentModuleName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "callees", {
                        get: function () {
                            return this._callees;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "atTopOfStack", {
                        get: function () {
                            return this._atTopOfStack;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "atBottomOfStack", {
                        get: function () {
                            return this._atBottomOfStack;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "resultId", {
                        get: function () {
                            return this._resultId;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "toolContext", {
                        get: function () {
                            return this._toolContext;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(CallerCalleeViewModel.prototype, "dataLoadStatus", {
                        get: function () {
                            return this._dataLoadStatus;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    CallerCalleeViewModel.prototype.navigateTo = function (viewModel, event) {
                        var context = ko.contextFor(event.target);
                        if (context && context.$data && context.$data.address) {
                            var toolContext = this._toolContext();
                            this._cpuToolMarshaler.raiseContextChangedEvent({
                                previousContext: toolContext,
                                currentContext: {
                                    viewContextSelectionAddress: context.$data.address
                                },
                                sender: CpuUsage.ContextChangedSender.CallerCalleeView
                            });
                            return false;
                        }
                        return true;
                    };
                    CallerCalleeViewModel.prototype.moveToNextFunction = function (viewModel, event) {
                        var focusTarget;
                        var targetElement = event.target;
                        if (event.keyCode === DiagnosticsHub.Common.KeyCodes.ArrowDown) {
                            if (targetElement.classList.contains("functions")) {
                                focusTarget = targetElement.firstElementChild;
                            }
                            else if (targetElement.classList.contains("function")) {
                                focusTarget = targetElement.nextElementSibling;
                            }
                        }
                        else if (event.keyCode === DiagnosticsHub.Common.KeyCodes.ArrowUp) {
                            if (targetElement.classList.contains("functions")) {
                                focusTarget = targetElement.lastElementChild;
                            }
                            else if (targetElement.classList.contains("function")) {
                                focusTarget = targetElement.previousElementSibling;
                            }
                        }
                        else {
                            return true;
                        }
                        if (focusTarget) {
                            focusTarget.focus();
                        }
                        return false;
                    };
                    CallerCalleeViewModel.prototype.computeCurrentFunctionName = function () {
                        var currentFunction = this.currentFunction();
                        return currentFunction ? currentFunction.name : "";
                    };
                    CallerCalleeViewModel.prototype.computeCurrentModuleName = function () {
                        var currentFunction = this.currentFunction();
                        return currentFunction ? currentFunction.moduleName : "";
                    };
                    CallerCalleeViewModel.prototype.loadData = function () {
                        var _this = this;
                        if (this._dataLoadPromise) {
                            this._dataLoadPromise.cancel();
                        }
                        this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadStart);
                        this._currentResult = this._dataWarehouse.getResultById(this._resultId());
                        var customData = {
                            view: "caller-callee",
                            type: CpuUsage.ResultTaskType.GetData,
                            functionLimit: this._functionLimit
                        };
                        if (this._toolContext().viewContextSelectionAddress) {
                            customData.functionAddress = this._toolContext().viewContextSelectionAddress;
                        }
                        this._dataLoadPromise = this._currentResult.getResult(customData)
                            .then(function (result) {
                            if (typeof result.id !== "number") {
                                _this._currentFunction(null);
                                _this._callers([]);
                                _this._callees([]);
                                return;
                            }
                            var callers = result.callers
                                .map(function (caller) { return new CpuUsage.CallerCalleeFunctionViewModel(caller); });
                            var callees = result.callees
                                .map(function (callee) { return new CpuUsage.CallerCalleeFunctionViewModel(callee); });
                            _this._currentFunction(new CpuUsage.CallerCalleeFunctionViewModel(result));
                            _this._callers(callers);
                            _this._callees(callees);
                            var previousContext = _this._toolContext();
                            var currentContext = { viewContextSelectionAddress: result.address };
                            if (!CpuUsage.CpuSamplingUtilities.areToolContextsEqual(previousContext, currentContext)) {
                                _this._cpuToolMarshaler.raiseContextChangedEvent({
                                    previousContext: previousContext,
                                    currentContext: currentContext,
                                    sender: CpuUsage.ContextChangedSender.CallerCalleeView
                                });
                            }
                        });
                        this._dataLoadPromise.done(function () {
                            _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCompleted);
                            _this._dataLoadPromise = null;
                        }, function (error) {
                            if (error.name === CpuUsage.Constants.errorNameCanceled) {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadCanceled);
                            }
                            else {
                                _this._dataLoadStatus(CpuUsage.DataLoadEvent.DataLoadFailed);
                            }
                            _this._dataLoadPromise = null;
                        });
                    };
                    return CallerCalleeViewModel;
                }());
                CpuUsage.CallerCalleeViewModel = CallerCalleeViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var ToolWindowViewModel = (function () {
                    function ToolWindowViewModel() {
                        var _this = this;
                        this._availableViews = [];
                        this._currentView = ko.observable(null);
                        this._previousView = null;
                        this._resultStatus = ko.observable(null);
                        this._toolContext = ko.observable(null);
                        this._toolContext.equalityComparer = CpuUsage.CpuSamplingUtilities.areToolContextsEqual;
                        this._resultStatus.equalityComparer = CpuUsage.CpuSamplingUtilities.areResultStatusesEqual;
                        var resultStatus;
                        var dataWarehouse;
                        var cpuToolMarshaler = new CpuUsage.CpuToolPortMarshaler();
                        Microsoft.VisualStudio.DiagnosticsHub.DataWarehouse.loadDataWarehouse()
                            .then(function (dw) {
                            dataWarehouse = dw;
                            return cpuToolMarshaler.getCurrentResultStatus();
                        })
                            .then(function (resStatus) {
                            resultStatus = resStatus;
                            return cpuToolMarshaler.getCurrentContext();
                        })
                            .done(function (toolContext) {
                            var callerCalleeViewModel = new CpuUsage.CallerCalleeViewModel(dataWarehouse, resultStatus.resultId, toolContext);
                            _this._callerCalleeView = {
                                name: Microsoft.Plugin.Resources.getString("CallerCalleeViewName"),
                                view: CpuUsage.Constants.callerCalleeViewModelMappingKey,
                                viewModel: callerCalleeViewModel,
                                toolbarItems: []
                            };
                            _this._availableViews.push(_this._callerCalleeView);
                            var callTreeViewModel = new CpuUsage.CallTreeViewModel(dataWarehouse, resultStatus.resultId, toolContext);
                            var searchControlViewModel = new CpuUsage.SearchControlViewModel(callTreeViewModel.gridViewModel, true);
                            _this._availableViews.push({
                                name: Microsoft.Plugin.Resources.getString("CallTreeViewName"),
                                view: CpuUsage.Constants.callTreeViewModelMappingKey,
                                viewModel: callTreeViewModel,
                                toolbarItems: [{ name: "SearchControlView", data: searchControlViewModel, afterRender: searchControlViewModel.onAfterDomInsert }]
                            });
                            _this._currentView(_this._callerCalleeView);
                            _this._resultStatus(resultStatus);
                            _this._currentOverlay = ko.pureComputed(function () { return _this.computeOverlay(); });
                            _this._isOverlayActive = ko.pureComputed(function () { return _this._currentOverlay() !== null; });
                            _this._currentView.subscribe(function (previousView) {
                                _this._previousView = previousView;
                            }, _this, "beforeChange");
                            _this._isOverlayActive.subscribe(function (isOverlayActive) { return searchControlViewModel.isDisabled(isOverlayActive); });
                            _this._currentView.subscribe(function (currentView) {
                                if (_this._previousView && _this._previousView.view !== currentView.view) {
                                    if (currentView.view === CpuUsage.Constants.callTreeViewModelMappingKey) {
                                        cpuToolMarshaler.raiseContextChangedEvent({
                                            previousContext: _this._toolContext(),
                                            currentContext: {},
                                            sender: CpuUsage.ContextChangedSender.CallTreeView
                                        });
                                    }
                                    if (currentView.view === CpuUsage.Constants.callerCalleeViewModelMappingKey) {
                                        cpuToolMarshaler.raiseContextChangedEvent({
                                            previousContext: _this._toolContext(),
                                            currentContext: {
                                                viewContextSelectionAddress: _this._toolContext().viewContextSelectionAddress
                                            },
                                            sender: CpuUsage.ContextChangedSender.CallerCalleeView
                                        });
                                    }
                                }
                                if (_this._resultStatus().preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                                    currentView.viewModel.toolContext(_this._toolContext());
                                    currentView.viewModel.resultId(_this._resultStatus().resultId);
                                }
                            });
                            _this._toolContext.subscribe(function (toolContext) {
                                if (_this._resultStatus().preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                                    _this._currentView().viewModel.toolContext(toolContext);
                                }
                            });
                            _this._resultStatus.subscribe(function (resultStatus) { return _this.onResultStatusChanged(resultStatus); });
                            cpuToolMarshaler.contextChangedEvent.addEventListener(_this.onToolContextChangedEvent.bind(_this));
                            cpuToolMarshaler.resultStatusUpdatedEvent.addEventListener(function (eventArgs) { return _this._resultStatus(eventArgs.currentResultStatus); });
                            _this._toolContext(toolContext);
                            ko.applyBindings(_this);
                        });
                    }
                    Object.defineProperty(ToolWindowViewModel.prototype, "availableViews", {
                        get: function () {
                            return this._availableViews;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ToolWindowViewModel.prototype, "currentView", {
                        get: function () {
                            return this._currentView;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ToolWindowViewModel.prototype, "currentOverlay", {
                        get: function () {
                            return this._currentOverlay;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    ToolWindowViewModel.prototype.onToolContextChangedEvent = function (eventArgs) {
                        if (eventArgs.sender === CpuUsage.ContextChangedSender.FlatFunctionsView) {
                            this._currentView(this._callerCalleeView);
                        }
                        this._toolContext(eventArgs.currentContext);
                    };
                    ToolWindowViewModel.prototype.onResultStatusChanged = function (resultStatus) {
                        if (resultStatus.preparationStatus === CpuUsage.ResultPreparationStatus.Completed) {
                            this._currentView().viewModel.resultId(resultStatus.resultId);
                        }
                    };
                    ToolWindowViewModel.prototype.computeOverlay = function () {
                        var currentViewModel = this._currentView().viewModel;
                        if (currentViewModel.dataLoadStatus() === CpuUsage.DataLoadEvent.DataLoadFailed) {
                            return {
                                name: "MessageView",
                                data: Microsoft.Plugin.Resources.getString("CpuDetailsViewUnableShowData")
                            };
                        }
                        return null;
                    };
                    return ToolWindowViewModel;
                }());
                CpuUsage.ToolWindowViewModel = ToolWindowViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CallTreeDAO = (function () {
                    function CallTreeDAO(dataWarehouse) {
                        this._dataWarehouse = dataWarehouse;
                    }
                    CallTreeDAO.prototype.getRoots = function (resultId, sortInfo) {
                        this._currentResult = this._dataWarehouse.getResultById(resultId);
                        return this._currentResult.getResult({
                            view: "call-tree",
                            type: CpuUsage.ResultTaskType.Expand,
                            sort: sortInfo,
                            path: []
                        })
                            .then(function (rootsResult) {
                            var roots = rootsResult.callTreeData.map(function (rootItem) {
                                return new CpuUsage.CallTreeRowViewModel(null, rootItem, 0);
                            });
                            return Microsoft.Plugin.Promise.as(roots);
                        });
                    };
                    CallTreeDAO.prototype.sort = function (roots, sortInfo) {
                        var sortFunc = CpuUsage.SortFunctions.getSortFunction(sortInfo);
                        var sortChildren = function (element) {
                            element.children.sort(sortFunc);
                            element.children().forEach(sortChildren);
                        };
                        roots.sort(sortFunc);
                        roots.forEach(sortChildren);
                        return Microsoft.Plugin.Promise.as(roots);
                    };
                    CallTreeDAO.prototype.search = function (query, isCaseSensitive, isRegex, startingRow, sortInfo) {
                        var idPath = startingRow ? startingRow.getIdPath() : [];
                        return this._currentResult.getResult({
                            view: "call-tree",
                            type: CpuUsage.ResultTaskType.Search,
                            selectedPath: idPath,
                            sort: sortInfo,
                            str: query,
                            caseSensitive: isCaseSensitive,
                            isRegex: isRegex
                        });
                    };
                    CallTreeDAO.prototype.expand = function (row, sortInfo) {
                        return row.expand(this._currentResult, sortInfo);
                    };
                    return CallTreeDAO;
                }());
                CpuUsage.CallTreeDAO = CallTreeDAO;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var ColumnResizer = (function () {
                    function ColumnResizer(headerColumn, header, tableColumn, table, rightSibling, columnConfig, columnProvider) {
                        this._leftOffset = null;
                        this._columnWidth = null;
                        this._initialX = null;
                        this._initialHeaderWidth = null;
                        this._minWidth = null;
                        this._hidden = false;
                        this._headerColumn = headerColumn;
                        this._header = header;
                        this._tableColumn = tableColumn;
                        this._table = table;
                        this._rightSibling = rightSibling;
                        this._minWidth = 40;
                        this._columnWidth = columnConfig.width;
                        this._id = columnConfig.columnId;
                        this._hidden = false;
                        this._columnProvider = columnProvider;
                        this._resizer = document.createElement("div");
                        this._resizer.classList.add("columnResizer");
                        this._resizer.style.width = this.width + "px";
                        this._resizer.onmousedown = this.onMouseDown.bind(this);
                        this._resizer.onmousemove = this.onMouseMove.bind(this);
                        this._resizer.onmouseup = this.onMouseUp.bind(this);
                        this._headerColumn.style.width = this._columnWidth + "px";
                        this._tableColumn.style.width = this._columnWidth + "px";
                        this._header.parentElement.insertAdjacentElement("afterBegin", this._resizer);
                    }
                    Object.defineProperty(ColumnResizer.prototype, "width", {
                        get: function () {
                            return 8;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(ColumnResizer.prototype, "columnConfig", {
                        get: function () {
                            return {
                                columnId: this._id,
                                isHidden: this._hidden,
                                width: this._columnWidth,
                            };
                        },
                        enumerable: true,
                        configurable: true
                    });
                    ColumnResizer.prototype.onColumnVisiblityChanged = function (visible) {
                        DiagnosticsHub.Debug.Assert.isFalse(this._hidden !== visible, "We should not be getting column visiblity changed for the same state");
                        if (this._hidden !== visible) {
                            return;
                        }
                        this._hidden = !visible;
                        var delta = this._hidden ? -this._columnWidth : this._columnWidth;
                        var headerWidth = parseInt(this._header.style.width.slice(0, -2));
                        this._header.style.width = (headerWidth + delta) + "px";
                        this._table.style.width = (headerWidth + delta) + "px";
                        this._resizer.style.display = this._hidden ? "none" : "";
                        if (this._rightSibling) {
                            this._rightSibling.onOffsetLeftChange(delta, false);
                        }
                    };
                    ColumnResizer.prototype.onAfterDomInsert = function () {
                        this._leftOffset = this._headerColumn.offsetLeft + this._headerColumn.offsetWidth - Math.floor(this.width / 2);
                        this._resizer.style.left = this._leftOffset + "px";
                    };
                    ColumnResizer.prototype.onOffsetLeftChange = function (delta, isIntermittent) {
                        this._resizer.style.left = (this._leftOffset + delta) + "px";
                        if (!isIntermittent) {
                            this._leftOffset += delta;
                        }
                        if (this._rightSibling) {
                            this._rightSibling.onOffsetLeftChange(delta, isIntermittent);
                        }
                    };
                    ColumnResizer.prototype.onMouseDown = function (event) {
                        if (this._initialX !== null) {
                            this.onMouseUp(event);
                            return;
                        }
                        this._initialX = event.clientX;
                        this._initialHeaderWidth = parseInt(this._header.style.width.slice(0, -2));
                        DiagnosticsHub.Utilities.setCapture(this._resizer);
                    };
                    ColumnResizer.prototype.onMouseMove = function (event) {
                        if (this._initialX === null) {
                            return;
                        }
                        this.updateDom(event.clientX, true);
                    };
                    ColumnResizer.prototype.onMouseUp = function (event) {
                        if (this._initialX === null) {
                            return;
                        }
                        DiagnosticsHub.Utilities.releaseCapture(this._resizer);
                        this.updateDom(event.clientX, false);
                        this._initialX = null;
                        this._initialHeaderWidth = null;
                    };
                    ColumnResizer.prototype.updateDom = function (clientX, isIntermittent) {
                        var delta = clientX - this._initialX;
                        var width = Math.max(this._columnWidth + delta, this._minWidth);
                        delta = width - this._columnWidth;
                        this._header.style.width = (this._initialHeaderWidth + delta) + "px";
                        this._headerColumn.style.width = (this._columnWidth + delta) + "px";
                        this._resizer.style.left = (this._leftOffset + delta) + "px";
                        if (this._rightSibling) {
                            this._rightSibling.onOffsetLeftChange(delta, isIntermittent);
                        }
                        if (!isIntermittent) {
                            this._table.style.width = (this._initialHeaderWidth + delta) + "px";
                            this._tableColumn.style.width = (this._columnWidth + delta) + "px";
                            this._columnWidth += delta;
                            this._leftOffset += delta;
                            this._columnProvider.onColumnChanged(this.columnConfig);
                        }
                    };
                    return ColumnResizer;
                }());
                CpuUsage.ColumnResizer = ColumnResizer;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var CpuToolColumnProvider = (function () {
                    function CpuToolColumnProvider(templateName) {
                        this._marshaler = new CpuUsage.CpuToolPortMarshaler;
                        this._templateName = templateName;
                    }
                    CpuToolColumnProvider.prototype.getColumnConfig = function () {
                        return this._marshaler.getColumnConfig(this._templateName);
                    };
                    CpuToolColumnProvider.prototype.onColumnChanged = function (column) {
                        this._marshaler.onColumnChanged(this._templateName, column);
                    };
                    return CpuToolColumnProvider;
                }());
                CpuUsage.CpuToolColumnProvider = CpuToolColumnProvider;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
                var TreeGridHeaderViewModel = (function () {
                    function TreeGridHeaderViewModel(templateName, columnProvider) {
                        var _this = this;
                        this._hiddenColumns = ko.observableArray([]);
                        this._syncScrollBoundFunction = this.syncScroll.bind(this);
                        this._sortColumn = ko.observable(CpuUsage.SortColumn.InclusiveSamples);
                        this._sortDirection = ko.observable(CpuUsage.SortDirection.Desc);
                        this._sortInfo = ko.pureComputed(function () {
                            return {
                                column: _this._sortColumn(),
                                direction: _this._sortDirection()
                            };
                        });
                        this._templateName = templateName;
                        this._columnProvider = columnProvider;
                    }
                    Object.defineProperty(TreeGridHeaderViewModel.prototype, "templateName", {
                        get: function () {
                            return this._templateName;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridHeaderViewModel.prototype, "hiddenColumns", {
                        get: function () {
                            return this._hiddenColumns;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridHeaderViewModel.prototype, "sortInfo", {
                        get: function () {
                            return this._sortInfo;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridHeaderViewModel.prototype, "sortColumn", {
                        get: function () {
                            return this._sortColumn;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    Object.defineProperty(TreeGridHeaderViewModel.prototype, "sortDirection", {
                        get: function () {
                            return this._sortDirection;
                        },
                        enumerable: true,
                        configurable: true
                    });
                    TreeGridHeaderViewModel.prototype.onAfterDomInsert = function (headerContainer, bodyContainer) {
                        var _this = this;
                        this._headerContainer = headerContainer;
                        this._bodyContainer = bodyContainer;
                        this._header = this._headerContainer.querySelector("table");
                        this._body = this._bodyContainer.querySelector("table");
                        var rightSibling = null;
                        var headerColumns = this._header.querySelectorAll("td");
                        var tableColumns = this._body.querySelectorAll("td");
                        var tableWidth = 0;
                        this._resizers = [];
                        return this._columnProvider.getColumnConfig()
                            .done(function (columnData) {
                            DiagnosticsHub.Debug.Assert.isTrue(headerColumns.length === columnData.length, "Header config is invalid");
                            for (var columnNumber = headerColumns.length - 1; columnNumber >= 0; --columnNumber) {
                                var resizer = new CpuUsage.ColumnResizer(headerColumns[columnNumber], _this._header, tableColumns[columnNumber], _this._body, rightSibling, columnData[columnNumber], _this._columnProvider);
                                _this._resizers.push(resizer);
                                rightSibling = resizer;
                                tableWidth += columnData[columnNumber].width;
                            }
                            _this._resizers = _this._resizers.reverse();
                            _this._header.style.width = tableWidth + "px";
                            _this._body.style.width = tableWidth + "px";
                            _this._resizers.forEach(function (resizer) {
                                resizer.onAfterDomInsert();
                            });
                            window.addEventListener("resize", _this._syncScrollBoundFunction);
                            _this._bodyContainer.addEventListener("scroll", _this._syncScrollBoundFunction);
                            var subscription = _this._hiddenColumns.subscribe(_this.onHiddenColumnsChanged.bind(_this), null, "arrayChange");
                            ko.utils.domNodeDisposal.addDisposeCallback(_this._bodyContainer, function () {
                                window.removeEventListener("resize", _this._syncScrollBoundFunction);
                                _this._bodyContainer.removeEventListener("scroll", _this._syncScrollBoundFunction);
                                subscription.dispose();
                                _this._hiddenColumns.removeAll();
                            });
                            columnData.forEach(function (columnConfig, index) {
                                if (columnConfig.isHidden) {
                                    _this._hiddenColumns.push(index);
                                }
                            });
                        });
                    };
                    TreeGridHeaderViewModel.prototype.syncScroll = function () {
                        var width = this._bodyContainer.clientWidth;
                        var scroll = this._bodyContainer.scrollLeft;
                        this._headerContainer.style.width = width + "px";
                        this._headerContainer.scrollLeft = scroll;
                    };
                    TreeGridHeaderViewModel.prototype.onHiddenColumnsChanged = function (changes) {
                        var _this = this;
                        changes.forEach(function (change) {
                            if (change.status === "added") {
                                _this._headerContainer.classList.add("hide" + change.value);
                                _this._bodyContainer.classList.add("hide" + change.value);
                                _this._resizers[change.value].onColumnVisiblityChanged(false);
                                _this._columnProvider.onColumnChanged(_this._resizers[change.value].columnConfig);
                            }
                            else if (change.status === "deleted") {
                                _this._headerContainer.classList.remove("hide" + change.value);
                                _this._bodyContainer.classList.remove("hide" + change.value);
                                _this._resizers[change.value].onColumnVisiblityChanged(true);
                                _this._columnProvider.onColumnChanged(_this._resizers[change.value].columnConfig);
                            }
                        });
                    };
                    return TreeGridHeaderViewModel;
                }());
                CpuUsage.TreeGridHeaderViewModel = TreeGridHeaderViewModel;
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var Microsoft;
(function (Microsoft) {
    var VisualStudio;
    (function (VisualStudio) {
        var DiagnosticsHub;
        (function (DiagnosticsHub) {
            var CpuUsage;
            (function (CpuUsage) {
                "use strict";
            })(CpuUsage = DiagnosticsHub.CpuUsage || (DiagnosticsHub.CpuUsage = {}));
        })(DiagnosticsHub = VisualStudio.DiagnosticsHub || (VisualStudio.DiagnosticsHub = {}));
    })(VisualStudio = Microsoft.VisualStudio || (Microsoft.VisualStudio = {}));
})(Microsoft || (Microsoft = {}));
var CpuUsage = Microsoft.VisualStudio.DiagnosticsHub.CpuUsage;
ko.bindingHandlers["virtualizedForEach"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var hiddenTop = document.createElement("div");
        var hiddenBottom = document.createElement("div");
        hiddenTop.innerHTML = "&nbsp;";
        hiddenTop.style.height = "0px";
        hiddenBottom.innerHTML = "&nbsp;";
        hiddenBottom.style.height = "0px";
        element.parentElement.insertAdjacentElement("beforeBegin", hiddenTop);
        element.parentElement.insertAdjacentElement("afterEnd", hiddenBottom);
        ko.utils.domData.set(element, "previousRows", []);
        ko.utils.domData.set(element, "rowHeight", 0);
        ko.utils.domData.set(element, "hiddenTop", hiddenTop);
        ko.utils.domData.set(element, "hiddenBottom", hiddenBottom);
        Microsoft.Plugin.Theme.addEventListener("themechanged", function () {
            ko.utils.domData.set(element, "rowHeight", 0);
        });
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var config = valueAccessor();
        var allRows = ko.unwrap(config.rows);
        var scrollTop = ko.unwrap(config.scrollTop);
        var clientHeight = ko.unwrap(config.clientHeight);
        var hiddenTop = ko.utils.domData.get(element, "hiddenTop");
        var hiddenBottom = ko.utils.domData.get(element, "hiddenBottom");
        var previousRows = ko.utils.domData.get(element, "previousRows");
        var rowHeight = ko.utils.domData.get(element, "rowHeight");
        if (rowHeight === 0) {
            if (allRows.length === 0) {
                return;
            }
            var rowBindingContext = bindingContext.createChildContext(allRows[0]);
            rowHeight = ko.bindingHandlers.virtualizedForEach.measureRowHeight(element, allRows[0], rowBindingContext);
            ko.utils.domData.set(element, "rowHeight", rowHeight);
        }
        var rowsToRemoveAtTop = Math.floor(scrollTop / rowHeight);
        var maxVisibleRows = Math.floor(clientHeight / rowHeight) + 2;
        var bufferSize = Math.floor(maxVisibleRows / 2);
        var endSlice = Math.min(allRows.length, rowsToRemoveAtTop + maxVisibleRows + bufferSize);
        rowsToRemoveAtTop = Math.max(rowsToRemoveAtTop - bufferSize, 0);
        hiddenTop.style.height = (rowsToRemoveAtTop * rowHeight) + "px";
        var visibleRows = allRows.slice(rowsToRemoveAtTop, endSlice);
        hiddenBottom.style.height = ((allRows.length - endSlice) * rowHeight) + "px";
        var differences = ko.bindingHandlers.virtualizedForEach.calculateNeededChanges(visibleRows, previousRows);
        differences.removedElements.forEach(function (change) {
            var rowElement = element.children[change.index];
            element.removeChild(rowElement);
        });
        differences.addedElements.forEach(function (change) {
            var renderedRow = document.createDocumentFragment();
            var rowBindingContext = bindingContext.createChildContext(change.value);
            ko.renderTemplate(change.value.templateName, rowBindingContext, {}, renderedRow, "replaceChildren");
            element.insertBefore(renderedRow, element.children[change.index] || null);
        });
        differences.movedElements.forEach(function (change) {
            element.insertBefore(element.children[change.fromIndex], element.children[change.toIndex]);
        });
        ko.utils.domData.set(element, "previousRows", visibleRows);
    },
    calculateNeededChanges: function (newArray, oldArray) {
        var intermediateArray = oldArray.slice(0);
        var arrayChanges = {
            removedElements: [],
            addedElements: [],
            movedElements: []
        };
        for (var i = oldArray.length - 1; i >= 0; --i) {
            if (newArray.indexOf(oldArray[i]) === -1) {
                arrayChanges.removedElements.push({ value: oldArray[i], index: i });
                intermediateArray.splice(i, 1);
            }
        }
        for (var i = 0; i < newArray.length; i++) {
            if (oldArray.indexOf(newArray[i]) === -1) {
                arrayChanges.addedElements.push({ value: newArray[i], index: i });
                intermediateArray.splice(i, 0, newArray[i]);
            }
        }
        for (var i = 0; i < intermediateArray.length; i++) {
            if (intermediateArray[i] === newArray[i]) {
                continue;
            }
            var fromIndex = intermediateArray.indexOf(newArray[i]);
            arrayChanges.movedElements.push({ fromIndex: fromIndex, toIndex: i });
            var movedElement = intermediateArray.splice(fromIndex, 1)[0];
            intermediateArray.splice(i, 0, movedElement);
        }
        return arrayChanges;
    },
    measureRowHeight: function (element, viewModel, dataOrBindingContext) {
        var renderedTemplate = document.createDocumentFragment();
        ko.renderTemplate(viewModel.templateName, dataOrBindingContext, {}, renderedTemplate, "replaceChildren");
        var measuringRow = renderedTemplate.firstChild;
        element.appendChild(measuringRow);
        var dimensions = measuringRow.getBoundingClientRect();
        element.removeChild(measuringRow);
        return dimensions.height;
    }
};
ko.bindingHandlers["rowIndent"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        element.style.display = "inline-block";
        element.style.textOverflow = "ellipsis";
        element.style.width = "calc(100% - 1em)";
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var indent = ko.unwrap(valueAccessor());
        element.style.maxWidth = indent + "em";
    }
};
ko.bindingHandlers["focusedRow"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var logger = Microsoft.VisualStudio.DiagnosticsHub.getLogger();
        var multiSelectStart = -1;
        element.addEventListener("keydown", function (event) {
            if (Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.Shift === event.keyCode) {
                var bindingConfig = valueAccessor();
                multiSelectStart = ko.unwrap(bindingConfig.focused);
                return;
            }
            if (Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.ArrowUp !== event.keyCode &&
                Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.ArrowDown !== event.keyCode) {
                return;
            }
            var bindingConfig = valueAccessor();
            var rows = ko.unwrap(bindingConfig.rows);
            if (rows.length === 0) {
                return;
            }
            var focusedIndex = ko.unwrap(bindingConfig.focused);
            var selectedIndex = 0;
            if (Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.ArrowUp === event.keyCode && focusedIndex !== -1) {
                selectedIndex = Math.max(focusedIndex - 1, 0);
            }
            else if (Microsoft.VisualStudio.DiagnosticsHub.Common.KeyCodes.ArrowDown === event.keyCode && focusedIndex !== -1) {
                selectedIndex = Math.min(focusedIndex + 1, rows.length - 1);
            }
            if (!event.shiftKey) {
                bindingConfig.selected([selectedIndex]);
            }
            else {
                var start = Math.max(Math.min(selectedIndex, multiSelectStart), 0);
                var end = Math.max(selectedIndex, multiSelectStart);
                var selection = [];
                for (var indexToSelect = start; indexToSelect <= end; ++indexToSelect) {
                    selection.push(indexToSelect);
                }
                if (multiSelectStart > selectedIndex) {
                    selection.reverse();
                }
                bindingConfig.selected(selection);
            }
            event.preventDefault();
        });
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var bindingConfig = valueAccessor();
        var focusedIndex = ko.unwrap(bindingConfig.focused);
        if (focusedIndex === -1) {
            return;
        }
        var rows = ko.unwrap(bindingConfig.rows);
        var scrollTop = element.scrollTop;
        var totalHeight = element.scrollHeight;
        var rowHeight = totalHeight / (rows.length + 1);
        var visibleHeight = element.clientHeight - rowHeight;
        var topPosition = focusedIndex * rowHeight;
        if (topPosition < (scrollTop + rowHeight)) {
            element.scrollTop = Math.max(topPosition - rowHeight, 0);
        }
        else if (topPosition + rowHeight > (scrollTop + (visibleHeight))) {
            element.scrollTop = topPosition + rowHeight - visibleHeight;
        }
    }
};
ko.bindingHandlers["visibilityContextMenu"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var bindings = valueAccessor();
        var hiddenColumnArray = bindings.hiddenColumns;
        var contextConfig = bindings.columns.map(function (binding) {
            var isChecked = function () {
                return hiddenColumnArray.indexOf(binding.columnNumber) === -1;
            };
            var callback = function () {
                if (isChecked()) {
                    hiddenColumnArray.push(binding.columnNumber);
                }
                else {
                    hiddenColumnArray.remove(binding.columnNumber);
                }
            };
            return {
                type: Microsoft.Plugin.ContextMenu.MenuItemType.checkbox,
                label: Microsoft.Plugin.Resources.getString(binding.localizedText),
                callback: callback,
                checked: isChecked
            };
        });
        var contextMenu = Microsoft.Plugin.ContextMenu.create(contextConfig);
        contextMenu.attach(element);
    }
};
ko.bindingHandlers["multiClick"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var events = valueAccessor();
        var doubleClickTimeMs = 500;
        var doubleClickTimer = null;
        var clickHandler = function (event) {
            if (doubleClickTimer !== null) {
                clearTimeout(doubleClickTimer);
                doubleClickTimer = null;
                events.dblclick.apply(viewModel, [viewModel, event]);
            }
            else {
                events.click.apply(viewModel, [viewModel, event]);
                doubleClickTimer = setTimeout(function () {
                    doubleClickTimer = null;
                }, doubleClickTimeMs);
            }
            event.preventDefault();
        };
        var portMarshaler = new Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.CpuToolPortMarshaler();
        portMarshaler.getDoubleClickTimeMs().then(function (doubleClickMs) {
            doubleClickTimeMs = doubleClickMs;
        });
        element.addEventListener("click", clickHandler, false);
    }
};
ko.bindingHandlers["sortable"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        element.onclick = function () {
            var value = valueAccessor();
            var elementColumnNumber = value.sortColumnNumber;
            var currentColumnNumber = value.currentColumn;
            var currentSortDirection = value.currentDirection;
            if (currentColumnNumber() === elementColumnNumber) {
                currentSortDirection(currentSortDirection() === Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.SortDirection.Asc ?
                    Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.SortDirection.Desc :
                    Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.SortDirection.Asc);
            }
            else {
                var defaultDirection = value.defaultDirection || Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.SortDirection.Desc;
                currentColumnNumber(elementColumnNumber);
                currentSortDirection(defaultDirection);
            }
        };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var value = valueAccessor();
        var elementColumnNumber = value.sortColumnNumber;
        element.classList.remove("sortAsc");
        element.classList.remove("sortDesc");
        if (elementColumnNumber === value.currentColumn()) {
            var sortedClass = value.currentDirection() === Microsoft.VisualStudio.DiagnosticsHub.CpuUsage.SortDirection.Asc ?
                "sortAsc" : "sortDesc";
            element.classList.add(sortedClass);
        }
    }
};
ko.bindingHandlers["treeGridExpander"] = {
    init: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        element.className = "treeGridRow-expander";
        return { controlsDescendantBindings: true };
    },
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var expanded = ko.unwrap(valueAccessor());
        if (expanded) {
            element.classList.add("expanded");
        }
        else {
            element.classList.remove("expanded");
        }
    }
};
ko.virtualElements.allowedBindings["treeGridExpander"] = false;
ko.bindingHandlers["progress"] = {
    update: function (element, valueAccessor, allBindingsAccessor, viewModel, bindingContext) {
        var progressValue = valueAccessor();
        var progressElement = element;
        if (progressValue.max) {
            progressElement.max = ko.unwrap(progressValue.max);
        }
        progressElement.value = ko.unwrap(progressValue.value);
    }
};
//# sourceMappingURL=CpuUsage.js.map
// SIG // Begin signature block
// SIG // MIIj/gYJKoZIhvcNAQcCoIIj7zCCI+sCAQExDzANBglg
// SIG // hkgBZQMEAgEFADB3BgorBgEEAYI3AgEEoGkwZzAyBgor
// SIG // BgEEAYI3AgEeMCQCAQEEEBDgyQbOONQRoqMAEEvTUJAC
// SIG // AQACAQACAQACAQACAQAwMTANBglghkgBZQMEAgEFAAQg
// SIG // qrwF6gbmBN2KHCydCJEssZxQB6OygZ7vwYqfum0oU1Cg
// SIG // gg2TMIIGETCCA/mgAwIBAgITMwAAAI6HkaRXGl/KPgAA
// SIG // AAAAjjANBgkqhkiG9w0BAQsFADB+MQswCQYDVQQGEwJV
// SIG // UzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMH
// SIG // UmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBv
// SIG // cmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29kZSBT
// SIG // aWduaW5nIFBDQSAyMDExMB4XDTE2MTExNzIyMDkyMVoX
// SIG // DTE4MDIxNzIyMDkyMVowgYMxCzAJBgNVBAYTAlVTMRMw
// SIG // EQYDVQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRt
// SIG // b25kMR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRp
// SIG // b24xDTALBgNVBAsTBE1PUFIxHjAcBgNVBAMTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjCCASIwDQYJKoZIhvcNAQEB
// SIG // BQADggEPADCCAQoCggEBANCH1EIrfp3ZxnrUosPjFZLS
// SIG // U52VF8lSNvpUv6sQr+nJ58wmU8PCc79t1gDlANzpamc0
// SIG // MPYWF7QBpZV8i7mkLOaLO3n2Iwx5j/NS30ABHMLGA53r
// SIG // Wc9z6dhxOZvwziVZLdLJWwrvftYyDl10EgTsngRTpmsC
// SIG // Z/hNWYt34Csh4O/ApEUSzwN7A8Y5w9Qi3FVcd0L/nLLl
// SIG // VWdoui12an9mU0fVRwrMON6Ne5cZfYLQJviljuWh8F5k
// SIG // EOT56yfG8uAI0A3yZ8DY8i/7idoV+a4PPgCXB9ELPnDU
// SIG // d6tyeEGYB7gXzKKxX+y981Bno9eU8NKLVY9TppWT5rJm
// SIG // z8k3aORjx88CAwEAAaOCAYAwggF8MB8GA1UdJQQYMBYG
// SIG // CisGAQQBgjdMCAEGCCsGAQUFBwMDMB0GA1UdDgQWBBSr
// SIG // yNbtshXSqo7xzO1sOPdFStCKuzBSBgNVHREESzBJpEcw
// SIG // RTENMAsGA1UECxMETU9QUjE0MDIGA1UEBRMrMjMwMDEy
// SIG // K2IwNTBjNmU3LTc2NDEtNDQxZi1iYzRhLTQzNDgxZTQx
// SIG // NWQwODAfBgNVHSMEGDAWgBRIbmTlUAXTgqoXNzcitW2o
// SIG // ynUClTBUBgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vd3d3
// SIG // Lm1pY3Jvc29mdC5jb20vcGtpb3BzL2NybC9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3JsMGEGCCsGAQUF
// SIG // BwEBBFUwUzBRBggrBgEFBQcwAoZFaHR0cDovL3d3dy5t
// SIG // aWNyb3NvZnQuY29tL3BraW9wcy9jZXJ0cy9NaWNDb2RT
// SIG // aWdQQ0EyMDExXzIwMTEtMDctMDguY3J0MAwGA1UdEwEB
// SIG // /wQCMAAwDQYJKoZIhvcNAQELBQADggIBAESJAqxpU/PE
// SIG // trvUjGBT58psqElpZr6lmkGZOtid0lcCUWr6v5uW26Ym
// SIG // fQlW6NztJXV6pUdSqB5LFlPz7g+awwSVKcGChKRWMfyg
// SIG // ipGVtb9azqkBH2RGoebK8dd0e7+SCFFefDMCXlE7m+XY
// SIG // Ll8CTAmcGkPace3k2eei2nQsF63lDLUY9VQJ1L4cc80g
// SIG // e6T6yNvY2zqu+pDFo72VZa5GLVcpWNaS8GzaY/GPM6J+
// SIG // OHZe3fM17ayaO2KB0E4ZfEh8sAuPOMwtvNU5ZamVwQPi
// SIG // ksm5q9JXCqrcUgsuViej4piXV468qVluJJKOguIJc4LZ
// SIG // NYPMn3/RBI6IuOKag1iw1JrmMfqUR459puJOefPY02oz
// SIG // FlBw8UK7mAnp/8yVVVsIv5JSqAjE8ejx/0DX+Zo2nf26
// SIG // kIXSVT5QrUYf7yUMuJ46SARj73iYol0DDQLY3CCr5la1
// SIG // 3u8WZsPXVYIeT4J4yZ5UGhBgtxerQBORrrAZwZozne4y
// SIG // cs1lzE9GmC0PUWAefPv+2+gHeQf3oTM4/gma2497tjq9
// SIG // hYa4zLx9ATC3ex2pXRu9zE0X925HM9VA32rKLlG4tbnP
// SIG // wwTTO+Xj6RCM66e63qQuM2opLxRK6h7BIjg1BYXvwgQA
// SIG // DWvB2JYUSBWvflKwuGDEUrVKgreFKgBJKiaDJ1pB3r3V
// SIG // Zkm8C5x4cAm8MIIHejCCBWKgAwIBAgIKYQ6Q0gAAAAAA
// SIG // AzANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMCVVMx
// SIG // EzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcTB1Jl
// SIG // ZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jwb3Jh
// SIG // dGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3QgQ2Vy
// SIG // dGlmaWNhdGUgQXV0aG9yaXR5IDIwMTEwHhcNMTEwNzA4
// SIG // MjA1OTA5WhcNMjYwNzA4MjEwOTA5WjB+MQswCQYDVQQG
// SIG // EwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UE
// SIG // BxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENv
// SIG // cnBvcmF0aW9uMSgwJgYDVQQDEx9NaWNyb3NvZnQgQ29k
// SIG // ZSBTaWduaW5nIFBDQSAyMDExMIICIjANBgkqhkiG9w0B
// SIG // AQEFAAOCAg8AMIICCgKCAgEAq/D6chAcLq3YbqqCEE00
// SIG // uvK2WCGfQhsqa+laUKq4BjgaBEm6f8MMHt03a8YS2Avw
// SIG // OMKZBrDIOdUBFDFC04kNeWSHfpRgJGyvnkmc6Whe0t+b
// SIG // U7IKLMOv2akrrnoJr9eWWcpgGgXpZnboMlImEi/nqwhQ
// SIG // z7NEt13YxC4Ddato88tt8zpcoRb0RrrgOGSsbmQ1eKag
// SIG // Yw8t00CT+OPeBw3VXHmlSSnnDb6gE3e+lD3v++MrWhAf
// SIG // TVYoonpy4BI6t0le2O3tQ5GD2Xuye4Yb2T6xjF3oiU+E
// SIG // GvKhL1nkkDstrjNYxbc+/jLTswM9sbKvkjh+0p2ALPVO
// SIG // VpEhNSXDOW5kf1O6nA+tGSOEy/S6A4aN91/w0FK/jJSH
// SIG // vMAhdCVfGCi2zCcoOCWYOUo2z3yxkq4cI6epZuxhH2rh
// SIG // KEmdX4jiJV3TIUs+UsS1Vz8kA/DRelsv1SPjcF0PUUZ3
// SIG // s/gA4bysAoJf28AVs70b1FVL5zmhD+kjSbwYuER8ReTB
// SIG // w3J64HLnJN+/RpnF78IcV9uDjexNSTCnq47f7Fufr/zd
// SIG // sGbiwZeBe+3W7UvnSSmnEyimp31ngOaKYnhfsi+E11ec
// SIG // XL93KCjx7W3DKI8sj0A3T8HhhUSJxAlMxdSlQy90lfdu
// SIG // +HggWCwTXWCVmj5PM4TasIgX3p5O9JawvEagbJjS4NaI
// SIG // jAsCAwEAAaOCAe0wggHpMBAGCSsGAQQBgjcVAQQDAgEA
// SIG // MB0GA1UdDgQWBBRIbmTlUAXTgqoXNzcitW2oynUClTAZ
// SIG // BgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMAQTALBgNVHQ8E
// SIG // BAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAfBgNVHSMEGDAW
// SIG // gBRyLToCMZBDuRQFTuHqp8cx0SOJNDBaBgNVHR8EUzBR
// SIG // ME+gTaBLhklodHRwOi8vY3JsLm1pY3Jvc29mdC5jb20v
// SIG // cGtpL2NybC9wcm9kdWN0cy9NaWNSb29DZXJBdXQyMDEx
// SIG // XzIwMTFfMDNfMjIuY3JsMF4GCCsGAQUFBwEBBFIwUDBO
// SIG // BggrBgEFBQcwAoZCaHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNSb29DZXJBdXQyMDExXzIw
// SIG // MTFfMDNfMjIuY3J0MIGfBgNVHSAEgZcwgZQwgZEGCSsG
// SIG // AQQBgjcuAzCBgzA/BggrBgEFBQcCARYzaHR0cDovL3d3
// SIG // dy5taWNyb3NvZnQuY29tL3BraW9wcy9kb2NzL3ByaW1h
// SIG // cnljcHMuaHRtMEAGCCsGAQUFBwICMDQeMiAdAEwAZQBn
// SIG // AGEAbABfAHAAbwBsAGkAYwB5AF8AcwB0AGEAdABlAG0A
// SIG // ZQBuAHQALiAdMA0GCSqGSIb3DQEBCwUAA4ICAQBn8oal
// SIG // mOBUeRou09h0ZyKbC5YR4WOSmUKWfdJ5DJDBZV8uLD74
// SIG // w3LRbYP+vj/oCso7v0epo/Np22O/IjWll11lhJB9i0ZQ
// SIG // VdgMknzSGksc8zxCi1LQsP1r4z4HLimb5j0bpdS1HXeU
// SIG // OeLpZMlEPXh6I/MTfaaQdION9MsmAkYqwooQu6SpBQyb
// SIG // 7Wj6aC6VoCo/KmtYSWMfCWluWpiW5IP0wI/zRive/DvQ
// SIG // vTXvbiWu5a8n7dDd8w6vmSiXmE0OPQvyCInWH8MyGOLw
// SIG // xS3OW560STkKxgrCxq2u5bLZ2xWIUUVYODJxJxp/sfQn
// SIG // +N4sOiBpmLJZiWhub6e3dMNABQamASooPoI/E01mC8Cz
// SIG // TfXhj38cbxV9Rad25UAqZaPDXVJihsMdYzaXht/a8/jy
// SIG // FqGaJ+HNpZfQ7l1jQeNbB5yHPgZ3BtEGsXUfFL5hYbXw
// SIG // 3MYbBL7fQccOKO7eZS/sl/ahXJbYANahRr1Z85elCUtI
// SIG // EJmAH9AAKcWxm6U/RXceNcbSoqKfenoi+kiVH6v7RyOA
// SIG // 9Z74v2u3S5fi63V4GuzqN5l5GEv/1rMjaHXmr/r8i+sL
// SIG // gOppO6/8MO0ETI7f33VtY5E90Z1WTk+/gFcioXgRMiF6
// SIG // 70EKsT/7qMykXcGhiJtXcVZOSEXAQsmbdlsKgEhr/Xmf
// SIG // wb1tbWrJUnMTDXpQzTGCFcMwghW/AgEBMIGVMH4xCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xKDAmBgNVBAMTH01pY3Jvc29m
// SIG // dCBDb2RlIFNpZ25pbmcgUENBIDIwMTECEzMAAACOh5Gk
// SIG // Vxpfyj4AAAAAAI4wDQYJYIZIAWUDBAIBBQCgga4wGQYJ
// SIG // KoZIhvcNAQkDMQwGCisGAQQBgjcCAQQwHAYKKwYBBAGC
// SIG // NwIBCzEOMAwGCisGAQQBgjcCARUwLwYJKoZIhvcNAQkE
// SIG // MSIEIEZQH86YTWIjzN4xWF2hdq1yOgS1VqHkTLhmPXsM
// SIG // vsuGMEIGCisGAQQBgjcCAQwxNDAyoBiAFgBDAHAAdQBV
// SIG // AHMAYQBnAGUALgBqAHOhFoAUaHR0cDovL21pY3Jvc29m
// SIG // dC5jb20wDQYJKoZIhvcNAQEBBQAEggEAJEier3E/Rv4G
// SIG // D+7E6dmqLQPWVx9ZJe0GBCiK/s02jleypoEQiFYb95tH
// SIG // v28TataCpVYV/VXVIPfaNd1u/1u25dNLFTIx7/L1UcRu
// SIG // YwMrXf855dDDrsStabkemPvGef9fulC4Y08r/I5YDxIc
// SIG // KYkqyrDpiqEb2YCdchmXPY0nV5gZKvTPACuw5029hpxN
// SIG // kmslQdXWQkkk1DeY0ueHOAQLjTKqxLNYIzmLJ3ACVoas
// SIG // QJjSOKdAujkxQ7EJqLF6sqQaVVtJ5XcGHJhe1E8HusiB
// SIG // 1vrNcfcDcec5+We317cNgnaDruhHyn++SBE/HjbheKwh
// SIG // erY/zYA1vqc8LiBKPdABcqGCE00wghNJBgorBgEEAYI3
// SIG // AwMBMYITOTCCEzUGCSqGSIb3DQEHAqCCEyYwghMiAgED
// SIG // MQ8wDQYJYIZIAWUDBAIBBQAwggE9BgsqhkiG9w0BCRAB
// SIG // BKCCASwEggEoMIIBJAIBAQYKKwYBBAGEWQoDATAxMA0G
// SIG // CWCGSAFlAwQCAQUABCAOE1xfXmaPsn73wk9cAx5TSn9c
// SIG // Itd4jQYDtLr+8Ia8cAIGWIui7EIHGBMyMDE3MDIwOTAz
// SIG // NDMzNy42MzVaMAcCAQGAAgH0oIG5pIG2MIGzMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYD
// SIG // VQQLEx5uQ2lwaGVyIERTRSBFU046QzBGNC0zMDg2LURF
// SIG // RjgxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1w
// SIG // IFNlcnZpY2Wggg7QMIIGcTCCBFmgAwIBAgIKYQmBKgAA
// SIG // AAAAAjANBgkqhkiG9w0BAQsFADCBiDELMAkGA1UEBhMC
// SIG // VVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNVBAcT
// SIG // B1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBDb3Jw
// SIG // b3JhdGlvbjEyMDAGA1UEAxMpTWljcm9zb2Z0IFJvb3Qg
// SIG // Q2VydGlmaWNhdGUgQXV0aG9yaXR5IDIwMTAwHhcNMTAw
// SIG // NzAxMjEzNjU1WhcNMjUwNzAxMjE0NjU1WjB8MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNyb3NvZnQg
// SIG // VGltZS1TdGFtcCBQQ0EgMjAxMDCCASIwDQYJKoZIhvcN
// SIG // AQEBBQADggEPADCCAQoCggEBAKkdDbx3EYo6IOz8E5f1
// SIG // +n9plGt0VBDVpQoAgoX77XxoSyxfxcPlYcJ2tz5mK1vw
// SIG // FVMnBDEfQRsalR3OCROOfGEwWbEwRA/xYIiEVEMM1024
// SIG // OAizQt2TrNZzMFcmgqNFDdDq9UeBzb8kYDJYYEbyWEeG
// SIG // MoQedGFnkV+BVLHPk0ySwcSmXdFhE24oxhr5hoC732H8
// SIG // RsEnHSRnEnIaIYqvS2SJUGKxXf13Hz3wV3WsvYpCTUBR
// SIG // 0Q+cBj5nf/VmwAOWRH7v0Ev9buWayrGo8noqCjHw2k4G
// SIG // kbaICDXoeByw6ZnNPOcvRLqn9NxkvaQBwSAJk3jN/LzA
// SIG // yURdXhacAQVPIk0CAwEAAaOCAeYwggHiMBAGCSsGAQQB
// SIG // gjcVAQQDAgEAMB0GA1UdDgQWBBTVYzpcijGQ80N7fEYb
// SIG // xTNoWoVtVTAZBgkrBgEEAYI3FAIEDB4KAFMAdQBiAEMA
// SIG // QTALBgNVHQ8EBAMCAYYwDwYDVR0TAQH/BAUwAwEB/zAf
// SIG // BgNVHSMEGDAWgBTV9lbLj+iiXGJo0T2UkFvXzpoYxDBW
// SIG // BgNVHR8ETzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNSb29D
// SIG // ZXJBdXRfMjAxMC0wNi0yMy5jcmwwWgYIKwYBBQUHAQEE
// SIG // TjBMMEoGCCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NlcnRzL01pY1Jvb0NlckF1dF8y
// SIG // MDEwLTA2LTIzLmNydDCBoAYDVR0gAQH/BIGVMIGSMIGP
// SIG // BgkrBgEEAYI3LgMwgYEwPQYIKwYBBQUHAgEWMWh0dHA6
// SIG // Ly93d3cubWljcm9zb2Z0LmNvbS9QS0kvZG9jcy9DUFMv
// SIG // ZGVmYXVsdC5odG0wQAYIKwYBBQUHAgIwNB4yIB0ATABl
// SIG // AGcAYQBsAF8AUABvAGwAaQBjAHkAXwBTAHQAYQB0AGUA
// SIG // bQBlAG4AdAAuIB0wDQYJKoZIhvcNAQELBQADggIBAAfm
// SIG // iFEN4sbgmD+BcQM9naOhIW+z66bM9TG+zwXiqf76V20Z
// SIG // MLPCxWbJat/15/B4vceoniXj+bzta1RXCCtRgkQS+7lT
// SIG // jMz0YBKKdsxAQEGb3FwX/1z5Xhc1mCRWS3TvQhDIr79/
// SIG // xn/yN31aPxzymXlKkVIArzgPF/UveYFl2am1a+THzvbK
// SIG // egBvSzBEJCI8z+0DpZaPWSm8tv0E4XCfMkon/VWvL/62
// SIG // 5Y4zu2JfmttXQOnxzplmkIz/amJ/3cVKC5Em4jnsGUpx
// SIG // Y517IW3DnKOiPPp/fZZqkHimbdLhnPkd/DjYlPTGpQqW
// SIG // hqS9nhquBEKDuLWAmyI4ILUl5WTs9/S/fmNZJQ96LjlX
// SIG // dqJxqgaKD4kWumGnEcua2A5HmoDF0M2n0O99g/DhO3EJ
// SIG // 3110mCIIYdqwUB5vvfHhAN/nMQekkzr3ZUd46PioSKv3
// SIG // 3nJ+YWtvd6mBy6cJrDm77MbL2IK0cs0d9LiFAR6A+xuJ
// SIG // KlQ5slvayA1VmXqHczsI5pgt6o3gMy4SKfXAL1QnIffI
// SIG // rE7aKLixqduWsqdCosnPGUFN4Ib5KpqjEWYw07t0Mkvf
// SIG // Y3v1mYovG8chr1m1rtxEPJdQcdeh0sVV42neV8HR3jDA
// SIG // /czmTfsNv11P6Z0eGTgvvM9YBS7vDaBQNdrvCScc1bN+
// SIG // NR4Iuto229Nfj950iEkSMIIE2jCCA8KgAwIBAgITMwAA
// SIG // AKPvHyIggWPcpQAAAAAAozANBgkqhkiG9w0BAQsFADB8
// SIG // MQswCQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3Rv
// SIG // bjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWlj
// SIG // cm9zb2Z0IENvcnBvcmF0aW9uMSYwJAYDVQQDEx1NaWNy
// SIG // b3NvZnQgVGltZS1TdGFtcCBQQ0EgMjAxMDAeFw0xNjA5
// SIG // MDcxNzU2NDlaFw0xODA5MDcxNzU2NDlaMIGzMQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScwJQYD
// SIG // VQQLEx5uQ2lwaGVyIERTRSBFU046QzBGNC0zMDg2LURF
// SIG // RjgxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0YW1w
// SIG // IFNlcnZpY2UwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
// SIG // ggEKAoIBAQCp0R6XxxNp+Dg7FRfmSA75X4KsVJ0wGq0Q
// SIG // XdDyBfc/aIY3WtAAU+acbRxo8inH1v8xmFJNEbr1wWSG
// SIG // OjkJJ1ZJXp+hIRkpG8xaFuPzfQFVFyzp4ayW+8eZryhw
// SIG // AHUi+i5ylFRfutHFrDLU5dYeefCBowq+Y754aWfij4XR
// SIG // yb7If5CL5Lh+mK5vvipkCBpItzkhyGr0JEtgENRygHII
// SIG // OOlu+TtT7VnbJNRNYchb02ljADK9zLFRPetAuH+4vrty
// SIG // HcE4bN4Jjm4tmTpsRQjes09bbW2Akdkjm0iZTB7lEX+z
// SIG // F552kb3iJhYfEQAcOt+Z6Cz/7HUsWClwpxctKO6PtKNf
// SIG // AgMBAAGjggEbMIIBFzAdBgNVHQ4EFgQU+oW6ZmboRpna
// SIG // cJ+6ISVA2+DosXAwHwYDVR0jBBgwFoAU1WM6XIoxkPND
// SIG // e3xGG8UzaFqFbVUwVgYDVR0fBE8wTTBLoEmgR4ZFaHR0
// SIG // cDovL2NybC5taWNyb3NvZnQuY29tL3BraS9jcmwvcHJv
// SIG // ZHVjdHMvTWljVGltU3RhUENBXzIwMTAtMDctMDEuY3Js
// SIG // MFoGCCsGAQUFBwEBBE4wTDBKBggrBgEFBQcwAoY+aHR0
// SIG // cDovL3d3dy5taWNyb3NvZnQuY29tL3BraS9jZXJ0cy9N
// SIG // aWNUaW1TdGFQQ0FfMjAxMC0wNy0wMS5jcnQwDAYDVR0T
// SIG // AQH/BAIwADATBgNVHSUEDDAKBggrBgEFBQcDCDANBgkq
// SIG // hkiG9w0BAQsFAAOCAQEAHdFFulu0v4rmho1FzjWIJhJG
// SIG // sDODamExyBZz+OYkemrBwBU3PI3HKQ1Iy3SXpbKH4QZ4
// SIG // 1UOMUzrw4lEOeLbT/ByNJeVTGhXZPnq8x7vBTmZYURgP
// SIG // ZSVhIaG+5pHDYI75CbQ+iMKmcoE7HPIQHNUFrohdNFVS
// SIG // qEOGjPANVL5L5EvuF5W2m7wCaxbNsi1s9avfNeEGg7RZ
// SIG // QeceAfNoTffY3iQsRktCwI0Xc0RQK43eds1/dF3f5mTM
// SIG // MriewM9lUhEIBnqXtoNlo2LYw4O6OY5HuFOqw2YaHL1J
// SIG // TvTc1Aes0rjRZPngd8nsdoDEqxcr6yODtZaJ8dhLlpLd
// SIG // b6nCO9bznKGCA3kwggJhAgEBMIHjoYG5pIG2MIGzMQsw
// SIG // CQYDVQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQ
// SIG // MA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9z
// SIG // b2Z0IENvcnBvcmF0aW9uMQ0wCwYDVQQLEwRNT1BSMScw
// SIG // JQYDVQQLEx5uQ2lwaGVyIERTRSBFU046QzBGNC0zMDg2
// SIG // LURFRjgxJTAjBgNVBAMTHE1pY3Jvc29mdCBUaW1lLVN0
// SIG // YW1wIFNlcnZpY2WiJQoBATAJBgUrDgMCGgUAAxUANeSj
// SIG // +04//yYNcfVtXhJ7kZY4po2ggcIwgb+kgbwwgbkxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xDTALBgNVBAsTBE1PUFIxJzAl
// SIG // BgNVBAsTHm5DaXBoZXIgTlRTIEVTTjo1N0Y2LUMxRTAt
// SIG // NTU0QzErMCkGA1UEAxMiTWljcm9zb2Z0IFRpbWUgU291
// SIG // cmNlIE1hc3RlciBDbG9jazANBgkqhkiG9w0BAQUFAAIF
// SIG // ANxGKbswIhgPMjAxNzAyMDgyMzM1MjNaGA8yMDE3MDIw
// SIG // OTIzMzUyM1owdzA9BgorBgEEAYRZCgQBMS8wLTAKAgUA
// SIG // 3EYpuwIBADAKAgEAAgIFzAIB/zAHAgEAAgIXrTAKAgUA
// SIG // 3Ed7OwIBADA2BgorBgEEAYRZCgQCMSgwJjAMBgorBgEE
// SIG // AYRZCgMBoAowCAIBAAIDFuNgoQowCAIBAAIDB6EgMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQA7CFZEzuhDb9apV99ZJ0Rd
// SIG // G2FlsKYiMg7MOfyPC/gdgOTe3Wiq7RxKIQ1sDhfBVDl/
// SIG // KbOmrhbUAj+5arPG1nGSqJIyI9a4Ulq1wWSZ4P8kd60n
// SIG // 4lfHTSvvym04rhhTLmN2GHjYxTOkyHyThyC5am3iGXwW
// SIG // gmJgwH/Hmzvykkm4R7PKK2ZuYTcQdn6+ubRWOreM5O26
// SIG // 3QmIfL6Y7RAPXSBLaTDwn0LJLoTsqrg2J8invEQA6NJt
// SIG // V4p/2eYGvxmO5GIcfOqW51TCMGeKaJekrMwl4u1oBSvW
// SIG // AIr8edtX+zUG2sN0vydFWk1ml6fPsrXrgnUb55V1rB2t
// SIG // Eihp3r/aS57GMYIC9TCCAvECAQEwgZMwfDELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEmMCQGA1UEAxMdTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBIDIwMTACEzMAAACj7x8iIIFj3KUA
// SIG // AAAAAKMwDQYJYIZIAWUDBAIBBQCgggEyMBoGCSqGSIb3
// SIG // DQEJAzENBgsqhkiG9w0BCRABBDAvBgkqhkiG9w0BCQQx
// SIG // IgQgvN7dwWdvfpfl7HLEBKHSouMsES9hHjpkKXp929Wr
// SIG // aowwgeIGCyqGSIb3DQEJEAIMMYHSMIHPMIHMMIGxBBQ1
// SIG // 5KP7Tj//Jg1x9W1eEnuRljimjTCBmDCBgKR+MHwxCzAJ
// SIG // BgNVBAYTAlVTMRMwEQYDVQQIEwpXYXNoaW5ndG9uMRAw
// SIG // DgYDVQQHEwdSZWRtb25kMR4wHAYDVQQKExVNaWNyb3Nv
// SIG // ZnQgQ29ycG9yYXRpb24xJjAkBgNVBAMTHU1pY3Jvc29m
// SIG // dCBUaW1lLVN0YW1wIFBDQSAyMDEwAhMzAAAAo+8fIiCB
// SIG // Y9ylAAAAAACjMBYEFDQacyrzz0lo0GUGVI81VtibQ9e9
// SIG // MA0GCSqGSIb3DQEBCwUABIIBAIgUPPtJLG93MA7OBLUz
// SIG // kLBQiEBjUkO6GYqphxvUGzhgj5PKqUCQKLgkSIdI65fp
// SIG // HTQabpsD38KcnSGzCr8YCx+ZK+as+a1pgsteLbBYvqhh
// SIG // Tz091XsrAGr7lG2cJD7OmzZYzOGzZ7K8+Mif8B+i6jjG
// SIG // nEOPsFDUtpZM8I1woMZ5mo9d9sb3j4hkznoQAXPQjxP3
// SIG // qv3HuLPmGbLflUN6g1ELMK1dug4osgdJFflLndZVPuym
// SIG // e5pNtffWUssrHIHS1QOgwVis6hjGd1k/v/+UrH9kydna
// SIG // yI2RU5rwxiCE1B0i3lrrF2NnB5TemEYUiSb2kIM0Mna+
// SIG // mLY2H4SicPWKPsc=
// SIG // End signature block
